/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * virtual.h ---	Declares types and variables of the virtual machine.
 * (duz 09Oct94)
 */

/* *INDENT-OFF* */

#ifndef __VIRTUAL_H
#define __VIRTUAL_H

/* First the register assignments if GNU-C is used. ======================== */

#if !defined __GNUC__ || defined  __STRICT_ANSI__ || defined __cplusplus
# undef USE_REGS
#endif

#ifdef USE_REGS
# if defined AIX1

#   define REGIP "%ebx"

# elif defined Linux || defined FreeBSD || defined EMX || defined NeXTstep

#   define REGIP "%ebx"
#   define REGSP "%ebp"

# elif defined AIX3

#   define REGIP "13"
#   define REGSP "14"
#   define REGRP "15"
#   define REGW  "16"
#   define REGLP "17"
#   define REGFP "18"

# elif defined HPUX68K

#   define REGIP "%a3"
#   define REGSP "%a4"
#   define REGRP "%a5"
#   define REGW  "%d4"
#   define REGLP "%d5"

# elif defined HPUXRISC

#   define REGIP "%r13"
#   define REGSP "%r14"
#   define REGRP "%r15"
#   define REGW  "%r16"
#   define REGLP "%r17"
#   define REGFP "%r18"

# elif defined ULTRIX

#   define REGIP "$18"
#   define REGSP "$19"
#   define REGRP "$20"
#   define REGW  "$21"
#   define REGLP "$22"
#   define REGFP "$23"

# elif defined OSF1

#   define REGIP "$10"
#   define REGSP "$11"
#   define REGRP "$12"
#   define REGW  "$13"
#   define REGLP "$14"
#   define REGFP "$15"

# else

#   undef USE_REGS

# endif
#endif


/* The basic types: ======================================================== */

typedef CELL_TYPE		Cell;	/* a stack item */
typedef unsigned CELL_TYPE	uCell;	/* dito unsigned */
typedef struct
	{ Cell hi; uCell lo; }	dCell;	/* dito, double precision signed */
typedef struct
	{ uCell hi, lo; }	udCell;	/* dito, double precision unsigned */

typedef unsigned HALF_CELL_TYPE	hCell;	/* a smaller unsigned number */

typedef void (*pCode) (void);		/* pointer to executable code */
typedef pCode *Xt;			/* type of the "execution token" */

typedef struct { Cell	quot, rem; } fdiv_t;
typedef struct { uCell	quot, rem; } udiv_t;

typedef struct				/* "map" of a Cell */
{
#if HIGHBYTE_FIRST
  hCell	hi, lo;
#else
  hCell	lo, hi;
#endif
} Cell_map;


/* Virtual machine registers, declared as variables: ======================= */

#ifdef REGIP			/* the instruction pointer */
register Xt *	ip asm (REGIP);
#else
extern Xt *	ip;
#endif

#ifdef REGW			/* used inside the inner interpreter */
register Xt	W asm (REGW);
#else
# ifdef REGIP
#   define W	(ip [-1])
# else
extern Xt	W;
# endif
#endif

#ifdef REGSP			/* the stack pointer */
register Cell *	sp asm (REGSP);
#else
extern Cell *	sp;
#endif

#ifdef REGRP			/* the return stack pointer */
register Xt **	rp asm (REGRP);
#else
extern Xt **	rp;
#endif

#ifdef REGLP			/* pointer to local variables */
register Cell *	lp asm (REGLP);
#else
extern Cell *	lp;
#endif

#ifdef REGFP			/* the floating point stack pointer */
register double *fp asm (REGFP);
#else
extern double *	fp;
#endif


#endif /* ndef __VIRTUAL_H */
