## -*- Ruby -*-
## Sample XMLEncoding class for Japanese (EUC-JP, Shift_JIS)
## 1998 by yoshidam
##
## Usage:
##    require 'xmlencoding-ja'
##    include XMLEncoding_ja

module XMLEncoding_ja
  require 'xmlparser'
  require 'uconv'
  include Uconv
  require 'kconv'
  include Kconv

  class EUCHandler<XMLEncoding
    def map(i)
      return i if i < 128
      return -1 if i < 160 or i == 255
      return -2 
    end
    def convert(s)
      euctou2(s)
    end
  end

  class SJISHandler<XMLEncoding
    def map(i)
      return i if i < 128
      return -2 
    end
    def convert(s)
      euctou2(kconv(s, EUC, SJIS))
    end
  end

  def unknownEncoding(name)
    return EUCHandler.new if name =~ /^euc-jp$/i
    return SJISHandler.new if name =~ /^shift_jis$/i
    nil
  end

end

module XML
  Encoding_ja = XMLEncoding_ja
end
