int
afnet_init()
{
	/* Initialize UDP listener */
	/*
	rdnet_udp_init();
	*/
}
#if 0
/*
 * rdnet.c
 *
 * The network socket handler for the radiod server
 *
 * $Id: afnet.c,v 1.3 1996/08/08 02:53:05 ron Exp $
 *
 * $History$
 *
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <netinet/in.h>

static struct sockaddr_in tcpbind ;
static struct sockaddr_in tcpsender ;
static char buffer[80];
static int result ;
static int len, addrlen ;
static RDNET_CHANNEL udp_channel ;
static RDNET_MSG *freemsg ;
static RDNET_MSG msgs[RDNET_NUMMSG] ;
static struct sockaddr_in msg_addr[RDNET_NUMMSG] ;
void rdnet_udp_init() ;

afnet_tcp_init()
{
	/* UDP socket initialization */
	memset ( &tcpbind, 0, sizeof (tcpbind) ) ;
	tcpbind.sin_family = AF_INET ;
	tcpbind.sin_addr.s_addr = INADDR_ANY ;
	tcpbind.sin_port = INADDR_ANY ;
	tcp_channel.fd = socket ( AF_INET, SOCK_STREAM, 0 ) ;
	if ( result < 0 )
	{
		perror ( "rdnet_init: unable to create socket" ) ;
		exit ( -1 ) ;
	}
	result = bind ( tcp_channel.fd, 
					(struct sockaddr *)&udpbind, sizeof (udpbind) ) ;

	if ( result < 0 )
	{
		perror ( "rdnet_init: unable to bind" ) ;
		exit ( -1 ) ;
	}
}


#if 0
#include "rd.h"
#include "rdnet.h"
#include "rdmsg.h"


void
afnet_udp_init()
{
	/* UDP socket initialization */
	memset ( &udpbind, 0, sizeof (udpbind) ) ;
	udpbind.sin_family = AF_INET ;
	udpbind.sin_addr.s_addr = INADDR_ANY ;
	udpbind.sin_port = htons ( RD_PORT_NUM ) ;
	udp_channel.fd = socket ( AF_INET, SOCK_DGRAM, 0 ) ;
	if ( result < 0 )
	{
		perror ( "rdnet_init: unable to create socket" ) ;
		exit ( -1 ) ;
	}
	result = bind ( udp_channel.fd, 
					(struct sockaddr *)&udpbind, sizeof (udpbind) ) ;

	if ( result < 0 )
	{
		perror ( "rdnet_init: unable to bind" ) ;
		exit ( -1 ) ;
	}

	/* Initialize internal data structures */
	udp_channel.next = NULL ;
	udp_channel.debug = -1 ;
	udp_channel.channel_type = RDNETCHANTYPE_UDP ;
	udp_channel.addr_comp = rdnet_udp_addr_comp ;
	udp_channel.netsend = rdnet_udp_send ;

	rdloop_select_list_add( udp_channel.fd, rdnet_udp_handler, &udp_channel ) ;
}

/*
	rdnet_udp_handler is called from the select loop to deal with datagrams
	coming in on the network socket
*/
void
rdnet_udp_handler(void *private, int event )
{
	RDNET_CHANNEL *net  = private ;
	RDNET_MSG *msg = rdnet_newmsg();

	if (msg == NULL)
	{
		printf("rdnet_udp_handler: Internal message pool exhausted");
		exit(-1);
	}

	addrlen = sizeof(udpsender) ;
	msg->len = recvfrom ( net->fd, msg->data, RDNETMSGSIZE, 0, 
						  (struct sockaddr *)msg->addr, &addrlen );
	msg->chan = &udp_channel ;

	if ( net->debug & RDNET_TRACE_RAW )
	{
		printf("Message: from %x:%d\n",
			ntohl(((struct sockaddr_in *)msg->addr)->sin_addr.s_addr),
			ntohs(((struct sockaddr_in *)msg->addr)->sin_port) ) ;
		printf("len = %d. errno = %d. buffer: %s\n",msg->len,errno,msg->data);
	}
	rdio_proc_msg ( msg ) ;
}

/*
	rdnet_udp_send  provides the udp-specific send routine
*/
int
rdnet_udp_send (void *msgptr, void *msg, int len)
{
	RDNET_MSG *m = msgptr;

	if (len > RDNETMSGLEN)
		return -1 ;

	printf("rdnet_udp_send: about to call sendto\n");
	result = sendto ( m->chan->fd, msg, len, 
						0, 
						(struct sockaddr *)m->addr,
						sizeof(struct sockaddr) );
	if ( result < 0 )
		perror("udp_send");

	return 0 ;
}


/*
	rdnet_udp_addr_comp  provides an address comparison for UDP messages
*/
int 
rdnet_udp_addr_comp( void *a1, void *a2 )
{
	struct sockaddr_in  *ina1, *ina2 ;

	ina1 = a1 ;
	ina2 = a2 ;

	if ( ( ina1->sin_addr.s_addr == ina2->sin_addr.s_addr ) && 
	     ( ina1->sin_port == ina2->sin_port ) )
		return 0 ;
	else
		return -1 ;
}

#endif

#if 0
main()
{
	int unix_fd, udp_fd, tcp_fd ;
	struct sockaddr unix_sock_name ;
	struct sockaddr connectname ;
	struct sockaddr_in udpbind ;
	struct sockaddr_in udpsender ;
	int result ;
	int len, addrlen ;

	printf("rdnet: Initial socket test code.\n");

#if 0
	/* Unix named socket code */
	unix_fd = socket ( AF_UNIX, SOCK_STREAM, 0 );
	printf(" socket returned %d\n", unix_fd );

	unix_sock_name.sa_family = AF_UNIX ;
	strcpy ( unix_sock_name.sa_data, "/tmp/rdsock" );
	result = bind ( unix_fd, &unix_sock_name, sizeof (unix_sock_name) ) ;
	printf(" bind returned %d.  errno=%d\n", result, errno );

	/*
	len = sizeof(connectname) ;
	result = accept ( unix_fd, &connectname, &len ) ;
	printf("acceptname:result = %d. errno = %d. "
		"name:: %s\n", result, errno, connectname.sa_data );
	*/

	result = read ( unix_fd, buffer, 10 ) ;
	printf("read: len = %d. errno = %d. buffer: %s\n", result, errno, buffer );
#endif

#if 0
	/* UDP test */
	memset ( &udpbind, 0, sizeof (udpbind) ) ;
	udpbind.sin_family = AF_INET ;
	udpbind.sin_addr.s_addr = INADDR_ANY ;
	udpbind.sin_port = htons ( RD_PORT_NUM ) ;
	udp_fd = socket ( AF_INET, SOCK_DGRAM, 0 ) ;
	result = bind ( udp_fd, (struct sockaddr *)&udpbind, sizeof (udpbind) ) ;
	printf(" udp bind: result=%d. errno=%d.\n");

	addrlen = sizeof(udpsender) ;
	result = recvfrom ( udp_fd, buffer, 80, 0, 
						(struct sockaddr *)&udpsender,  &len );

	printf("len = %d. errno = %d. buffer: %s\n", result, errno, buffer );

	printf("Message from %x:%d\n",
		ntohl(udpsender.sin_addr.s_addr), ntohs(udpsender.sin_port) ) ;
#endif

}

#endif

#endif
