// qsodata.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _QSODATA_H_
#define _QSODATA_H_

#include <time.h>
#include "rdefs.h"

#define ARRL_SS_CONTEST                 1
#define ARRL_DX_CONTEST                 2      // ARRL DX contest from W/VE side
#define CQ_WW_CONTEST                   3
#define CQ_WPX_CONTEST                  4
#define IARU_CONTEST                    5
#define ARRL_10M_CONTEST                6
#define ARRL_160M_CONTEST               7
#define CQ_160M_CONTEST                 8
#define FD_CONTEST                      9
#define CAL_QP_CONTEST                 10
#define ARRL_DX_CONTEST_DX             11      // ARRL DX Contest from DX side
#define WAE_CONTEST                    12
#define ARRL_VHF_QSO_PARTY             13
#define DXPEDITION_MODE                14
#define ALL_ASIAN_CONTEST              15
#define NA_QSO_PARTY_CONTEST           16
#define GRIDLOC_CONTEST                17
#define YO_DX_CONTEST                  18
#define KCJ_CONTEST                    19      // Keyman's Club of Japan
#define TEN_TEN_CONTEST                20
#define NA_SPRINT_CONTEST              21
#define SAC_CONTEST                    22
#define TOEC_CONTEST                   23
#define JA_INTL_DX_CONTEST             24
#define QRP_ARCI_CONTEST               25
#define IOTA_CONTEST                   26
#define INTERNET_SPRINT_CONTEST        27
#define GENERAL_QSO                    28
#define STEW_PERRY_CONTEST             29
#define HELVETIA_CONTEST               30
#define WAG_CONTEST                    31
#define ARI_CONTEST                    32
#define MAX_CONTEST                    32

#define CAT_SINGLE_OP                   0
#define CAT_SINGLE_OP_UNLIMITED         1
#define CAT_MULTI_SINGLE                2
#define CAT_MULTI_TWO                   3
#define CAT_MULTI_MULTI                 4
#define CAT_QRP_SINGLE_OP               5
#define CAT_SINGLE_OP_LOW_POWER         6
#define CAT_SINGLE_OP_HIGH_POWER        7
#define CAT_ROVER                       8
#define CAT_LIMITED_MULTI               9
#define CAT_SINGLE_OP_SINGLE_BAND      10

#define HEADER_CALL_SIZE                32
#define HEADER_NAME_SIZE                32
#define HEADER_ADDRESS_SIZE             64
#define HEADER_CITY_SIZE                32
#define HEADER_STATE_SIZE               8
#define HEADER_ZIP_SIZE                 16
#define HEADER_GRID_SIZE                8
#define HEADER_CLUB_SIZE                64
#define HEADER_SECTION_SIZE             8

#define DEVICE_NONE                     0
#define DEVICE_TNC                      1
#define DEVICE_RADIO                    2
#define DEVICE_NETWORK                  3

#define TNC_NONE                        0
#define TNC_LOCAL                       1
#define TNC_DRSI                        2
#define TNC_REMOTE                      3

#define PORT_NONE                       0
#define PORT_COM1                       1
#define PORT_COM2                       2
#define PORT_COM3                       3
#define PORT_COM4                       4
#define PORT_LPT1                       5
#define PORT_LPT2                       6

#define COM_BAUD_1200                   0
#define COM_BAUD_2400                   1
#define COM_BAUD_4800                   2
#define COM_BAUD_9600                   3
#define COM_BAUD_19200                  4

typedef struct ssHeaderStruct {
    char                precedence;
    unsigned char      check;
    char                section[8];
} SSHeader;

typedef struct fdHeaderStruct {
    unsigned char       transmitters;
    char                 category;      // A=0, B=1, C=2, D=3, E=4  Should change this
                                        // to be the real character.
    char                 section[8];
    
    unsigned char       ep_bonus;
    unsigned char       pr_bonus;
    unsigned char       loc_bonus;
    unsigned char       info_bonus;
    unsigned char       msg_bonus;
    unsigned char       sat_bonus;
    unsigned char       nat_bonus;
    unsigned char       w1aw_bonus;
    unsigned char       pkt_bonus;
         unsigned char       power;
    unsigned char       tfc_bonus;
} FDHeader;

typedef struct headerdatastruct{
    char callsign[32];
    unsigned char contest;                      // Uses the _CONTEST defines above.
    unsigned char category;                     // Uses the CAT_ defines above.
    unsigned char mode;                         // 
    char contestName[32];
    char year[5];
    char name[32];
    char address[64];
    char city[32];
    char state[8];
    char zip[16];
         char club[64];

    unsigned char stationNumber;
    char lastOperator[16];                      // Used by CY v8 and v9 files.
    char radio[8];
    char *radio2;
    unsigned char tnc;                        // Uses the TNC_ defines above.
    unsigned char cwPort;                     // Uses PORT_ defines above.
    unsigned char dvkPort;                    // Uses PORT_ defines above.
    
    unsigned char zone;
    char grid[8];
    union {
        SSHeader ss;                            // Sweepstakes Header information.
        FDHeader fd;                            // Field Day Header information.
    };

    char CQ_CW_Message[64];
    char QRZ_CW_Message[64];
    char Exchange_CW_Message[64];
    char Dupe_CW_Message[32];
    char F6_CW_Message[64];
    char F7_CW_Message[64];

    struct comm_data {
        char device;                            // Uses the DEVICE_ defines above
        char baud;                              // Uses the COM_BAUD_ defines above
    } comm[4];

    struct dvp_data {                           // Parameters for DVP device.  Based on
        unsigned char ingain;                  //  CT v8 header format.
        unsigned char outgain;
                  unsigned char onair;
        unsigned char mon;
        char           ram_disk;
        unsigned char ptt;
        unsigned char backcopy;
        unsigned char spare;
        unsigned short clipping_pt;
        unsigned short rpt_delay;
        long           auto_space;
        unsigned char disable_send_ser;
        unsigned char disable_send_call;
    } dvp;

    struct flag_struct {
        unsigned char no_work_dupe;
        unsigned char m_stn;
                  unsigned char post;
        unsigned char beep;
        unsigned char band_rate;
        unsigned char sound;
        unsigned char correct;
        unsigned char cw_abbrev;
        unsigned char autosave;
        unsigned char nocompress;
        unsigned char see_warc;
        unsigned char print;
        unsigned char rpt;
        unsigned char kw_right;
    } flags;
} header_data;

#define QSO_DATA_CALL_SIZE    14
#define QSO_DATA_QTH_SIZE     30
#define QSO_DATA_STATE_SIZE   3

#define BAND_160M       1
#define BAND_80M        2
#define BAND_40M        3
#define BAND_30M        4
#define BAND_20M        5
#define BAND_18M        6
#define BAND_15M        7
#define BAND_12M        8
#define BAND_10M        9
#define BAND_50MHZ      10
#define BAND_76MHZ      11
#define BAND_144MHZ     12
#define BAND_222MHZ     13
#define BAND_432MHZ     14
#define BAND_902MHZ     15
#define BAND_1GHZ       16
#define BAND_2GHZ       17
#define BAND_3GHZ       18
#define BAND_5GHZ       19
#define BAND_10GHZ      20
#define BAND_24GHZ      21
#define BAND_47GHZ      22
#define BAND_76GHZ      23
#define BAND_119GHZ     24
#define BAND_142GHZ     25
#define BAND_241GHZ     26
#define BAND_SATELLITE  27
#define BAND_PACKET     28
#define BAND_NOVICE     29
#define BAND_LIGHT      30
#define MAX_BAND        30

#define CW_MODE         1
#define SSB_MODE        2
#define RTTY_MODE       3
#define AM_MODE         4
#define FM_MODE         5
#define AMTOR_MODE      6
#define PACKET_MODE     7
#define PACTOR_MODE     8
#define GTOR_MODE       9
#define MAX_MODE        9

#define INFO_SIZE       400

typedef struct ssInfoStruct {
    char                precedence;
    unsigned char      check;
} SSInfo;

typedef struct fdInfoStruct {
    unsigned char       transmitters;
    char                 category;
} FDInfo;

class qso_data {
    char              callsign[QSO_DATA_CALL_SIZE+1]; // Station worked
    time_t             time;                          // ANSI-UNIX time
    time_t             timeOff;                       // Time when QSO was finished.
         unsigned char    band;                          // See BAND_xx constants above.
    long              freq;                          // Full frequency in tenths of kHz.
         unsigned char    mode;                          // See xx_MODE constants above.
         unsigned char    contest;                       // Can be different in GENERAL_QSO mode.
         unsigned short   txPower;                       // Transmitter output power used.
         unsigned int     serialNumSent;                 // Serial Number given out.
         unsigned int     serialNumber;                  // Serial number.
         char              name[16];
         unsigned char    cqZone;                        // Start using these!
         unsigned char    ituZone;
         char              qth[QSO_DATA_QTH_SIZE];        // ADIF city, etc.
         char              section[5];                    // ARRL Section
         char              state[QSO_DATA_STATE_SIZE];    // Generally ADIF General QSO only
    unsigned short sentRST;
    unsigned short receivedRST;
    unsigned int tenTenNumber;
         unsigned short ARCInumber;        // Member number for ARCI Contest.  If not a member,
    unsigned char age;                // For All Asian Contest, primarily.
         char info[INFO_SIZE];              // Generic contest info (zone, grid, etc).
         union {
                  SSInfo ss;                      // Sweepstakes QSO information.
                  FDInfo fd;                      // Field Day QSO information.
         };
         unsigned char qsoPoints;          // Number of points for this QSO (TR and ARRL files only)
         unsigned char multCount;          // Number of mults for this QSO (TR and ARRL files only)
         char multipliers[16];              // Multipliers written out (TR files only).
         short qtc_num;                     // WAE QTC number (CT v8 style)
         unsigned char qsl_sent;
         unsigned char qsl_rcvd;
         unsigned char stationNumber;

public:
         qso_data()     {};
         void addMult(char *);

         const bool isInfoNumeric(void);

    const unsigned char getAge()            {return age;};
    const unsigned short getARCInumber()    {return ARCInumber;};
    const unsigned char getBand()           {return band;};
         const char *getCallsign()                {return callsign;};
    const unsigned char getCallsignLength();
    const unsigned char getContest()        {return contest;};
    const unsigned char getCqZone()         {return cqZone;};
    const unsigned long getFreq()           {return freq;};
         const char *getInfo()                    {return info;};
    const unsigned char getInfoLength();
    const unsigned char getItuZone()        {return ituZone;};
    const unsigned char getMode()           {return mode;};
    const int getMultCount()                 {return multCount;};
    const char *getMultipliers()             {return multipliers;};
    const char *getName()                    {return name;};
         const unsigned char getNameLength();
    const char getQslSent()                  {return qsl_sent;};
    const char getQslReceived()              {return qsl_rcvd;};
    const int getQsoPoints()                 {return qsoPoints;};
         const int getQtcNum()                    {return qtc_num;};
    const char *getQth()                     {return qth;};
    const unsigned char getQthLength();
    const int getReceivedRST()               {return receivedRST;};
    const char *getSection()                 {return section;};
    const int getSentRST()                   {return sentRST;};
         const unsigned int getSerialNumber()    {return serialNumber;};
    const char *getState()                   {return state;};
    const int getStationNumber()             {return stationNumber;};
    const unsigned int getTenTenNumber()    {return tenTenNumber;};
    const time_t getTime()                    {return time;};
    const time_t getTimeOff()                 {return timeOff;};
    const int getTxPower()                   {return txPower;};

    const char getFdCategory()               {return fd.category;};
    const unsigned char getFdTransmitters() {return fd.transmitters;};

         const int getSSCheck()                   {return ss.check;};
    const char getSSPrecedence()             {return ss.precedence;};

    void init();

         void setAge(char *);
    void setARCInumber(char *);
    void setBand(unsigned char b)           {band = b;};
    void setCallsign(char *);
    void setCallsign(char *, int);
    void setContest(unsigned char);
         void setCqZone(char *);
         void setCqZone(int zone)                    {cqZone = zone;};
         void setFreq(unsigned long f)           {freq = f;};
    void setInfo(char *);
    void setInfo(char *, int);
         void setItuZone(char *);
    void setMode(unsigned char m)           {mode = m;};
         void setMultCount(int count)             {multCount = count;};
    void setName(char *);
    void setQslSent(char);
         void setQslReceived(char);
    void setQsoPoints(char *);
         void setQtcNum(int num)                     {qtc_num = num;};
    void setQth(char *);
    void setQth(char *, int);
    void setReceivedRST(char *);
         void setReceivedRST(int rst)             {receivedRST = rst;};
    void setSection(char *);
    void setSection(char *, int);
    void setSentRST(char *);
         void setSentRST(int rst)                 {sentRST = rst;};
    void setSerialNumber(char *);
         void setSerialNumber(int num)               {serialNumber = num;};
    void setSerialNumberSent(char *);
    void setState(char *, int);
         void setStationNumber(int num)              {stationNumber = num;};
    void setTenTenNumber(char *);
         void setTime(int, int, int, int, int);
    void setTime(time_t newTime)              {time = newTime;};
    void setTimeOff(time_t newTime)           {timeOff = newTime;};
    void setTxPower(int);
    void setTxPower(char *);

    void setFdCategory(char cat)             {fd.category = cat;};
    void setFdTransmitters(char *);
         void setFdTransmitters(int count)           {fd.transmitters = count;};

    void setSSCheck(char *);
         void setSSCheck(int chk)                    {ss.check = chk;};
    void setSSPrecedence(char prec)          {ss.precedence = prec;};
};
#endif
