// arrlfile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _ARRLFILE_H_
#define _ARRLFILE_H_

#include "qsodata.h"
#include "qsofile.h"

class RArrlFile : public RQsoFile {
private:
//    int location;

    typedef struct log_data_struct {
        char band[4];
        char mode[4];
        char day[2];
        char slash1;
        char month[2];
        char slash2;
        char year[2];
        char filler;
        char time[4];
        char filler2;
        char qsoNum[6];
        char callsign[15];
        char sent[5];
        char rcvd[5];
        char mult[3];
        char qsoPoints[3];
        char WhatIsThis;
    } arrl_log_data;
    
public:
    static char *modes[];
    static char *bands[];
    static boolean contests[];
    
    RArrlFile()                     { location = 0; };
    RArrlFile(char *filename);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
    virtual boolean nextQso(qso_data *);       /* Return next generic QSO record */

    // Support for these will be added later.
    virtual boolean writeHeader(header_data);
    virtual boolean writeQso(qso_data *);
};
#endif
