// Misty earth-like terrain scene version 1.0 
// Copyright (c) 1999, 2000 David A. Bartold
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "colors.inc"
#include "skies.inc"


// TF_HEIGHT_FIELD
//
// Declares the height field object that's positioned with one corner at
// the origin

#ifndef (TF_HEIGHT_FIELD)
#declare TF_HEIGHT_FIELD = height_field { tga "TF_FILE" smooth }
#end

// TF_WATER_LEVEL
//
// The parameter is a float between [0.0, 0.9].  The smaller the number,
// the more land that is above water.

#ifndef (TF_WATER_LEVEL)
#declare TF_WATER_LEVEL = 0.33;
#end

// TF_Y_SCALE
//
// This parameter is a float between (0.0, 1.0].  Basically, it sets the
// height of the rendered terrain

#ifndef (TF_Y_SCALE)
#declare TF_Y_SCALE = 0.33;
#end



/////// End of User Definable Parameters ////////////////////////////////////

// Include files
#include "colors.inc"
#include "skies.inc"

light_source
{
  <0, 1.0, -0.75>
  color <1.0, 0.95, 0.8>
}


camera
{
  location <0, 0.75, -1.1> 		// View it all
  look_at <0, 0, 0>
}


// Create water
plane
{
  <0, 1, 0>, 0
  translate <0.0, 0.047, 0.0>
  texture
  {
    pigment { color <0.65, 0.75, 0.8, 0.95> }
    finish
    {
      specular 1.0
      reflection 0.2
      diffuse 0.4
    }
    normal
    {
      ripples 0.25
      frequency 100.0
    }
  }
  interior { ior 1.33 }
}


#declare T_silt =
texture
{
  // Sienna 
  pigment { color <0.9, 0.8, 0.6> }
}


// Soil near shore-line -- light-colored and wet. 
#declare T_soil =
texture
{
  // Burnt Sienna 
  pigment { color <0.8, 0.6, 0.4> }
  finish
  {
    roughness 0.0001
    diffuse 0.85
  }
}


#declare T_shrubbery =
texture
{
  pigment
  {
    gradient y
    turbulence 0.4
    omega 20.0
    pigment_map
    {
      [ 0.0 color <0.1, 0.8, 0.05> ]    /* Alive Green   */
      [ 1.0 color <0.05, 0.45, 0.2> ]   /* Forest Green  */
    }
  }
  finish
  {
    reflection 0.0
    diffuse 0.5
    roughness 0.5
  }
  normal
  {
    bumps 0.4
    scale 0.002
  }
}


#declare T_greenery =
texture
{ 
  pigment
  {
    bozo
    color_map
    {
      [0 color <0.6, 0.75, 0.3>]
      [1 color <0.2, 0.5, 0.1>]
    }
    scale 0.1
  }
  normal
  {
    bumps 0.25
    scale 0.001
  }
}


#declare T_yellowed =
texture
{
  pigment
  {
    gradient y
    turbulence 0.2
    omega 1.0
    pigment_map
    {
      [ 0.0 color <0.67, 0.7, 0.15> ]  // Yellow Green 
      [ 0.5 color <0.8, 0.6, 0.5> ]    // Brownish Color
      [ 1.0 color <0.67, 0.7, 0.15> ]  // Yellow Green
    }
  }
  finish
  {
    diffuse 0.9
    roughness 1.0
  }
  normal
  {
    bumps 0.2
    scale 0.001
  }
  scale 0.5
}


#declare T_snowtop =
texture
{
  pigment { White }
  finish
  {
    specular 0.6
    reflection 0.0
    diffuse 0.9
    roughness 0.01
  }
  normal
  {
    bumps 0.1
    scale 0.0002
  }
}


#declare T_mountaincap =
texture
{
  gradient y
  turbulence 0.5
  omega 0.05
  texture_map
  {
    [ 0.0 T_shrubbery ]    // Green plants 
    [ 0.42 T_yellowed ]    // Not-so-green foliage 
    [ 0.46 T_snowtop ]     // White (peaks) 
    [ 1.0 T_snowtop ]
  }
  scale 1.5
}


// Reddish Soil. 
#declare P_reddish =
pigment { color <0.65, 0.5, 0.3> }


#declare T_landwater =
texture
{
  pigment
  {
    gradient y
    turbulence 0.5
    omega 1.0
    pigment_map
    {
      [0.0 color <0.2, 0.5, 0.1> ]
      [0.10 color <0.2, 0.5, 0.1> ]
      [0.40 P_reddish ]
      [0.60 P_reddish ]
      [0.90 color <0.2, 0.5, 0.1> ]
      [1.0 color <0.2, 0.5, 0.1> ]
    }
    scale 0.1
  }
  normal
  {
    bumps 0.2
    scale 0.0005
  }
}


#declare WL = TF_WATER_LEVEL;

#declare T_landscape =
texture
{
  gradient y
  turbulence 0.05
  omega 0.75
  texture_map
  {
    [ 0.0 pigment   { color <0.05, 0.2, 0.4> } ]  	// Blue (water)
    [ WL/2  pigment  { color <0.3, 0.65, 0.9> } ]
    [ WL/2+0.05 T_silt ]				// Sienna
    [ WL/2+0.07 T_soil ]				// Burnt Sienna 
    [ WL/2+0.09 pigment { P_reddish } ]			// Reddish soil
    [ WL/2+0.12 T_landwater ]				// Between land and water 
    [ WL/2+0.14 T_greenery ]				// Dark, Rough Green
    [ WL/2+0.32 T_mountaincap ] 			// Additional foliage and possibly an ice cap 
  } 

  // Give us some leeway because texture maps wrap around. 
  // This value is determined empirically for glibc systems.
  // If mountains are topped by dark blue, increase the
  // scale value until the artifact disappears.
  scale 1.07
}


// Create Land
object
{
  TF_HEIGHT_FIELD
  texture { T_landscape }
  scale <1, TF_Y_SCALE, 1>
  translate <-0.5, 0, -0.5>
}


fog
{
  distance 0.3
  color <0.65, 0.65, 0.65>
  fog_type 2
  fog_offset 0.072
  fog_alt 0.05
  turbulence 0.2
}


sky_sphere
{
  S_Cloud1
}
