/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_WINDOW_BASE_H
#define _TF_WINDOW_BASE_H 1


#include "flexarray.h"
#include "GlobalSanityCheck.h"
#include "GuiDialogAbout.h"
#include "GuiDialogOAC.h"
#include "GuiDialogYN.h"
#include "GuiDialogReallyQuit.h"


/*
 *  TFWindowBase: base class to force passing of a valid FlexArray pointer 
 * 	to the inidividual TDWindow* objects as well as providing variables
 * 	for the dialogs shared by the main window and the idividual HF windows.
 */
class TFWindowBase 
	{
	public:
				TFWindowBase (FlexArray *wList);
				~TFWindowBase ();
		static FlexArray *getWinList () { return s_winList; }

	protected:
		static FlexArray	*s_winList;		
		static GuiDialogAbout	*s_aboutDialog;
		static GuiDialogOAC	*s_optionsDialog, 
					*s_mergeDialog;
		static GuiDialogYN	*s_printOptionsDialog;
		static GuiDialogReallyQuit *s_quitDialog;
		static Connection	s_quitDialogConnection;

	};



#endif // _TF_WINDOW_BASE_H
