/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_WINDOW_H
#define _TF_WINDOW_H 1


#include "GuiBufferedDrawingArea.h"			// include gtk, gtk--
#include "GuiColormap.h"
#include "GuiColormapLinear.h"
#include "GuiColormapBands.h"
#include "glib--hash.h"


/*
 *  TFWindow: the main (drawing) window for terraform. The Window includes: 
 * 	GuiBufferedDrawingArea (via inheritance)
 * 	Menu + Accelerators
 * 	either MenuBar or Popup Menu 
 */
class TFWindow : public GuiBufferedDrawingArea
	{
	public: 
				TFWindow (); 
				~TFWindow (); 
		virtual void 	quit ();
		virtual void	fileMenuCallback (string m);
		virtual void	hfMenuCallback (string m);
		virtual void	viewMenuCallback (string m);
		virtual void	colormapMenuCallback (string m);
		void		setSize (int x, int y);
		static char 	*buildAccel (char *menu, char accelType, char *s);
		Gtk_Window	*getWindow () {return &d_win;}

	protected: 
		//void		hide_impl ();
		//void		show_impl ();
		void		addMenus ();
		void		allocColormaps ();
		void		buildWindowFixedMenu ();
		void		buildWindowFloatingMenu ();

		Gtk_Window		d_win;
		Gtk_VBox 		d_vbox;
		Gtk_AccelGroup		d_accelGroup;
		Gtk_ItemFactory		*p_itemFactory;
		Gtk_ObjectHandle<Gtk_Menu>  d_menuHandle;
		Gtk_ObjectHandle<Gtk_MenuBar>  d_menuBarHandle;

		bool			d_useLinearColormap;
		int			d_nameCount;
		char			**p_mNames;
		Glib_Hash		*p_menuHash;
		GuiColormapLinear	*p_linearColorMap,
					*p_linearColorMap2;
		GuiColormapBands	*p_bandColorMap,
					*p_bandColorMap2;
	};


#endif // _TF_WINDOW_H

