/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogRotate.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogRotate::TFDialogRotate (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Rotate Dialog", 
			"Rotation Parameters", 6, 4),
		d_frmOptions (_("Rotate clockwise by")),
		d_tblRotate (6, 6, FALSE),
		d_lblR1 ("0"),
		d_lblR2 ("90"),
		d_lblR3 ("180"),
		d_lblR4 ("270"),
		d_lblUnit ("degrees")
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogRotate\n");
	p_RB1 = p_RB2 = p_RB3 = p_RB4 = NULL;
	buildDialogWindow ();
        this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Rotate: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
        this->iterateEvents ();
        updatePreviewCallback ();

	connect_to_method (p_RB1->clicked, this, &TFDialogRotate::updatePreviewCallback);
	connect_to_method (p_RB2->clicked, this, &TFDialogRotate::updatePreviewCallback);
	connect_to_method (p_RB3->clicked, this, &TFDialogRotate::updatePreviewCallback);
	connect_to_method (p_RB4->clicked, this, &TFDialogRotate::updatePreviewCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogRotate::~TFDialogRotate ()
{
	if (p_RB1) delete p_RB1;
	if (p_RB2) delete p_RB2;
	if (p_RB3) delete p_RB3;
	if (p_RB4) delete p_RB4;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogRotate\n");
}


/*
 *  insertOptions: fill the dialog's VBox
 */
void TFDialogRotate::insertOptions ()
{
	GSList		*radioGroup=NULL;

	// parameter settings  
	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (6);

	// table for p_RBs 
	d_tblRotate.set_row_spacings (8);
	d_tblRotate.set_col_spacings (1);
	d_tblRotate.set_border_width (6);
	d_frmOptions.add (d_tblRotate);

	// place the buttons 
	d_tblRotate.attach (d_lblR1, 2, 3 , 0, 1, 0, 0, 0, 0);
	d_lblR1.show ();
	p_RB1 = new Gtk_RadioButton (radioGroup);
	radioGroup = p_RB1->group();
	d_tblRotate.attach (*p_RB1, 2, 3, 1, 2, 0, 0, 0, 0);
	p_RB1->show ();

	d_tblRotate.attach (d_lblR2, 4, 5, 2, 3, 0, 0, 0, 0);
	d_lblR2.show ();
	p_RB2 = new Gtk_RadioButton (radioGroup);
	radioGroup = p_RB2->group();
	d_tblRotate.attach (*p_RB2, 3, 4, 2, 3, 0, 0, 0, 0);
	p_RB2->show ();

	d_tblRotate.attach (d_lblR3, 2, 3, 4, 5, 0, 0, 0, 0);
	d_lblR3.show ();
	p_RB3 = new Gtk_RadioButton (radioGroup);
	radioGroup = p_RB3->group();
	d_tblRotate.attach (*p_RB3, 2, 3, 3, 4, 0, 0, 0, 0);
	p_RB3->set_active (TRUE);
	p_RB3->show ();

	d_tblRotate.attach (d_lblR4, 0, 1, 2, 3, 0, 0, 0, 0);
	d_lblR4.show ();
	p_RB4 = new Gtk_RadioButton (radioGroup);
	radioGroup = p_RB4->group();
	d_tblRotate.attach (*p_RB4, 1, 2, 2, 3, 0, 0, 0, 0);
	p_RB4->show ();

	// place unit label
	d_tblRotate.attach (d_lblUnit, 5, 6, 5, 6, 0, 0, 0, 0);
	d_lblUnit.show ();

	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 3);
	d_tblRotate.show();
	d_frmOptions.show ();
	this->p_frmBase->show ();
        this->get_vbox()->show ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogRotate::buildDialogWindow ()
{
	this->set_usize (350, 225);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions ();
	this->fillActionArea ();

	this->show ();
}


/*
 *  buttonCallbackApply: rotate the Height Field
 */
void TFDialogRotate::buttonCallbackApply ()
{
	int		value=180; 

	if (p_RB1->get_active())
		value = 0;
	else
	if (p_RB2->get_active())
		value = 270;		// Rotate90 goes counterclockwise
	else
	if (p_RB3->get_active())
		value = 180;
	else
	if (p_RB4->get_active())
		value = 90;		// Rotate90 goes counterclockwise
	else
		SanityCheck::bailout ((TRUE), "Button out of range", "TFDialogRotate::buttonCallbackApply");

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogRotate::buttonCallbackApply");

	if (value)
		{
		p_HFO->rotate90 (value);
		p_HFD->draw ();

		// only do this if window stays open 
		if (b_applyHit)
			{
			this->setHFobjs (p_HF, p_HFD);
			updatePreviewCallback ();
			}
		}
	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a widget has been updated.
 */
void TFDialogRotate::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	int	value = 180;

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogFill");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogFill");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFDPreview==NULL", "TFDialogFill");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	if (p_RB1->get_active())
		value = 0;
	else
	if (p_RB2->get_active())
		value = 270;		// Rotate90 goes counterclockwise
	else
	if (p_RB3->get_active())
		value = 180;
	else
	if (p_RB4->get_active())
		value = 90;		// Rotate90 goes counterclockwise
	else
		SanityCheck::bailout ((TRUE), "Button out of range", "TFDialogRotate::buttonCallbackApply");
	p_HFOPreview->rotate90 (value);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
}

