/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogOptions.h"
#include "TFOptions.h"
#include "GlobalDefs.h"
#include "GlobalTrace.h"
#include "GlobalSanityCheck.h"
#include "HeightFieldDraw.h"
#include "TFWindowHandler.h"			// Circular dependency


/*
 *  constructor: initialize all data members. This is a global dialog
 * 	so we need a pointer to the window list rather than a specific
 * 	HeightField pointer. 
 */
TFDialogOptions::TFDialogOptions (FlexArray *wList)
	 : GuiDialogOAC (_("Terraform Options Dialog"), NULL),
	   d_frame1 (_("Global Draw Options")), 
	   d_frame2(_("Height Field Draw Options")),
	   d_frame3(_("Fast Wireframe Options")),
	   d_frame4(_("POV Render Options"))
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogOptions\n");

	SanityCheck::bailout ((!wList), "wList==NULL", "TFDialogOptions::TFDialogOptions");

	d_wList = wList;
	p_vb1 = new Gtk_VBox (TRUE, 2);
	p_vb2 = new Gtk_VBox (TRUE, 2);
	p_vb3 = new Gtk_VBox (TRUE, 2);
	p_vb4 = new Gtk_VBox (TRUE, 2);
	p_hb1_1 = new Gtk_HBox (TRUE, 5);
	p_hb1_2 = new Gtk_HBox (TRUE, 5);
	p_hb1_3 = new Gtk_HBox (TRUE, 5);
	p_hb1_4 = new Gtk_HBox (TRUE, 5);
	p_hb2_1 = new Gtk_HBox (TRUE, 5);
	p_hb2_2 = new Gtk_HBox (TRUE, 5);
	p_hb2_3 = new Gtk_HBox (TRUE, 5);
	p_hb3_1 = new Gtk_HBox (TRUE, 5);
	p_hb3_2 = new Gtk_HBox (TRUE, 5);
	p_hb3_3 = new Gtk_HBox (TRUE, 5);
	p_hb4_1 = new Gtk_HBox (TRUE, 5);
	p_hb4_2 = new Gtk_HBox (TRUE, 5);
	p_hb4_3 = new Gtk_HBox (TRUE, 5);
	p_hb4_4 = new Gtk_HBox (TRUE, 5);

	p_lblTitle1 = new Gtk_Label (_("Global"));
	p_lblTitle2 = new Gtk_Label (_("Height Field View"));
	p_lblTitle3 = new Gtk_Label (_("Fast Wireframe"));
	p_lblTitle4 = new Gtk_Label (_("PovRay"));
	p_lblScale = new Gtk_Label (_("Display Scale"));
	p_lblSync = new Gtk_Label (_("Sync Rate"));
	p_lblResolution = new Gtk_Label (_("Wireframe Resolution"));
	p_lblYScale = new Gtk_Label (_("Y Scale Factor"));
	p_lblSealevel = new Gtk_Label (_("Sealevel"));
	p_lblFillSea = new Gtk_Label (_("Sea is Filled"));
	p_lblDrawDerived = new Gtk_Label (_("Draw derived data"));
	p_lblFastResolution = new Gtk_Label (_("Half Wireframe Resolution"));
	p_lblFastYscale = new Gtk_Label (_("Half Y Scale Factor"));
	p_lblFastZrot = new Gtk_Label (_("Enable Z-axis rotation"));
	p_lblPOVfileName = new Gtk_Label (_("POV template file"));
	p_lblPOVwidth = new Gtk_Label (_("Render width"));
	p_lblPOVyscale = new Gtk_Label (_("Half Y scale"));
	p_lblPOVkeepFiles = new Gtk_Label (_("Keep generated files?"));

	p_adjScale = new Gtk_Adjustment (1.0, 1.0, 3.0, 1.0);
	p_adjSync = new Gtk_Adjustment (1, 1, 5000, 1);
	p_adjResolution = new Gtk_Adjustment (5.0, 1.0, 10.0, 1.0);
	p_adjYScale = new Gtk_Adjustment (0.33, 0, 1, 0.01, 10, 0);
	p_adjSealevel = new Gtk_Adjustment (0.33, 0, 1, 0.01, 10, 0);
	p_adjPOVwidth = new Gtk_Adjustment (400, 100, 1000, 1, 10, 0);

	p_hsScale = new Gtk_HScale (*p_adjScale);
	p_hsSync = new Gtk_HScale (*p_adjSync);
	p_hsResolution = new Gtk_HScale (*p_adjResolution);
	p_hsYScale = new Gtk_HScale (*p_adjYScale);
	p_hsSealevel = new Gtk_HScale (*p_adjSealevel);
	p_hsPOVwidth = new Gtk_HScale (*p_adjPOVwidth);

	buildDialogWindow ();
	updateSliders ();
}


/*
 *  destructor: clean up
 */
TFDialogOptions::~TFDialogOptions ()
{
	delete p_vb1;
	delete p_vb2;
	delete p_vb3;
	delete p_vb4;
	delete p_hb1_1;
	delete p_hb1_2;
	delete p_hb1_3;
	delete p_hb1_4;
	delete p_hb2_1;
	delete p_hb2_2;
	delete p_hb2_3;
	delete p_hb3_1;
	delete p_hb3_2;
	delete p_hb3_3;
	delete p_hb4_1;
	delete p_hb4_2;
	delete p_hb4_3;
	delete p_hb4_4;

	delete p_lblTitle1;
	delete p_lblTitle2;
	delete p_lblTitle3;
	delete p_lblTitle4;
	delete p_lblScale;
	delete p_lblSync;
	delete p_lblResolution;
	delete p_lblYScale;
	delete p_lblSealevel;
	delete p_lblFillSea;
	delete p_lblDrawDerived;
	delete p_lblFastResolution;
	delete p_lblFastYscale;
	delete p_lblFastZrot;
	delete p_lblPOVfileName;
	delete p_lblPOVwidth;
	delete p_lblPOVyscale;
	delete p_lblPOVkeepFiles;

	delete p_adjScale;
	delete p_adjSync;
	delete p_adjResolution;
	delete p_adjYScale;
	delete p_adjSealevel;
	delete p_adjPOVwidth;

	delete p_hsScale;
	delete p_hsSync;
	delete p_hsResolution;
	delete p_hsYScale;
	delete p_hsSealevel;
	delete p_hsPOVwidth;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogOptions\n");
}


/*
 *  updateSliders: update the sliders with new/changed values from TFOptions
 */
void TFDialogOptions::updateSliders ()
{
	d_cbFillSea.set_active (TFOptions::s_fillSea);
	p_adjScale->set_value (TFOptions::s_scale); 
	p_adjSync->set_value (TFOptions::s_syncRate);
	p_adjResolution->set_value (TFOptions::s_resolution); 
	p_adjYScale->set_value (TFOptions::s_yscale); 
	p_adjSealevel->set_value (TFOptions::s_sealevel); 
	d_cbFastResolution.set_active (TFOptions::s_fastHalfRes);
	d_cbFastYscale.set_active (TFOptions::s_fastHalfYscale);
	d_cbFastZrot.set_active (TFOptions::s_fastZrot);
}


/*
 *  fillVBox: fill the dialog's VBox
 */
void TFDialogOptions::fillVBox ()
{
	this->get_vbox()->pack_start (d_notebook, TRUE, TRUE, 0);
	d_frame1.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frame2.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frame3.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frame4.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_notebook.append_page (d_frame1, *p_lblTitle1);
	d_notebook.append_page (d_frame2, *p_lblTitle2);
	d_notebook.append_page (d_frame3, *p_lblTitle3);
	d_notebook.append_page (d_frame4, *p_lblTitle4);
	d_notebook.show ();

	buildDrawOptionsFrame ();
	buildHFDrawOptionsFrame ();
	buildFastWireOptionsFrame ();
	buildPOVOptionsFrame ();
}


/*
 *  buildDialogWindow:
 */
void TFDialogOptions::buildDialogWindow ()
{
	this->set_usize (350, 250);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	fillVBox ();
	fillActionArea ();

	this->show ();
}


/*
 *  buildDrawOptionsFrame: frame for the global draw options
 */
void TFDialogOptions::buildDrawOptionsFrame ()
{
	p_lblScale->set_justify (GTK_JUSTIFY_LEFT);
	p_hb1_1->pack_start (*p_lblScale, TRUE, TRUE, s_HBOff);
	p_lblScale->show ();
        p_hsScale->set_update_policy (GTK_UPDATE_DELAYED);
        p_hsScale->set_digits (0);
        p_hsScale->set_draw_value (TRUE);
	p_hb1_1->pack_start (*p_hsScale, TRUE, TRUE, s_HBOff);
        p_hsScale->show ();
	p_vb1->pack_start (*p_hb1_1, TRUE, TRUE, s_VBOff);
	p_hb1_1->show ();

	p_lblSync->set_justify (GTK_JUSTIFY_LEFT);
	p_hb1_2->pack_start (*p_lblSync, TRUE, TRUE, s_HBOff);
	p_lblSync->show ();
        p_hsSync->set_update_policy (GTK_UPDATE_DELAYED);
        p_hsSync->set_digits (0);
        p_hsSync->set_draw_value (TRUE);
	p_hb1_2->pack_start (*p_hsSync, TRUE, TRUE, s_HBOff);
        p_hsSync->show ();
	p_vb1->pack_start (*p_hb1_2, TRUE, TRUE, s_VBOff);
	p_hb1_2->show ();

	p_lblFillSea->set_justify (GTK_JUSTIFY_LEFT);
	p_hb1_3->pack_start (*p_lblFillSea, TRUE, TRUE, s_HBOff);
	p_lblFillSea->show ();
	d_cbFillSea.set_active (TRUE); 
	p_hb1_3->pack_start (d_cbFillSea, TRUE, TRUE, s_HBOff);
	d_cbFillSea.show ();
	p_vb1->pack_start (*p_hb1_3, TRUE, TRUE, s_VBOff);
	p_hb1_3->show ();

	p_lblDrawDerived->set_justify (GTK_JUSTIFY_LEFT);
	p_hb1_4->pack_start (*p_lblDrawDerived, TRUE, TRUE, s_HBOff);
	p_lblDrawDerived->show ();
	d_cbDrawDerived.set_active (TRUE); 
	p_hb1_4->pack_start (d_cbDrawDerived, TRUE, TRUE, s_HBOff);
	d_cbDrawDerived.show ();
	p_vb1->pack_start (*p_hb1_4, TRUE, TRUE, s_VBOff);
	p_hb1_4->show ();


	d_frame1.add (p_vb1);
	p_vb1->show ();
	d_frame1.show ();
}


/*
 *  buildHFDrawOptionsFrame: frame for the Height Field draw options
 */
void TFDialogOptions::buildHFDrawOptionsFrame ()
{
	p_lblResolution->set_justify (GTK_JUSTIFY_LEFT);
	p_hb2_1->pack_start (*p_lblResolution, TRUE, TRUE, s_HBOff);
	p_lblResolution->show ();
        p_hsResolution->set_update_policy (GTK_UPDATE_DELAYED);
        p_hsResolution->set_digits (0);
        p_hsResolution->set_draw_value (TRUE);
	p_hb2_1->pack_start (*p_hsResolution, TRUE, TRUE, s_HBOff);
        p_hsResolution->show ();
	p_vb2->pack_start (*p_hb2_1, TRUE, TRUE, s_VBOff);
	p_hb2_1->show ();

	p_lblYScale->set_justify (GTK_JUSTIFY_LEFT);
	p_hb2_2->pack_start (*p_lblYScale, TRUE, TRUE, s_HBOff);
	p_lblYScale->show ();
        p_hsYScale->set_update_policy (GTK_UPDATE_DELAYED);
        p_hsYScale->set_digits (2);
        p_hsYScale->set_draw_value (TRUE);
	p_hb2_2->pack_start (*p_hsYScale, TRUE, TRUE, s_HBOff);
        p_hsYScale->show ();
	p_vb2->pack_start (*p_hb2_2, TRUE, TRUE, s_VBOff);
	p_hb2_2->show ();

	p_lblSealevel->set_justify (GTK_JUSTIFY_LEFT);
	p_hb2_3->pack_start (*p_lblSealevel, TRUE, TRUE, s_HBOff);
	p_lblSealevel->show ();
        p_hsSealevel->set_update_policy (GTK_UPDATE_DELAYED);
        p_hsSealevel->set_digits (2);
        p_hsSealevel->set_draw_value (TRUE);
	p_hb2_3->pack_start (*p_hsSealevel, TRUE, TRUE, s_HBOff);
        p_hsSealevel->show ();
	p_vb2->pack_start (*p_hb2_3, TRUE, TRUE, s_VBOff);
	p_hb2_3->show ();

	d_frame2.add (p_vb2);
	p_vb2->show ();
	d_frame2.show ();
}

/*
 *  buildFastDrawOptionsFrame: frame for the Height Field draw options
 */
void TFDialogOptions::buildFastWireOptionsFrame ()
{
	p_lblFastResolution->set_justify (GTK_JUSTIFY_LEFT);
	p_hb3_1->pack_start (*p_lblFastResolution, TRUE, TRUE, s_HBOff);
	p_lblFastResolution->show ();
	d_cbFastResolution.set_active (TRUE);
	p_hb3_1->pack_start (d_cbFastResolution, TRUE, TRUE, s_HBOff);
	d_cbFastResolution.show ();
	p_vb3->pack_start (*p_hb3_1, TRUE, TRUE, s_VBOff);
	p_hb3_1->show ();

	p_lblFastYscale->set_justify (GTK_JUSTIFY_LEFT);
	p_hb3_2->pack_start (*p_lblFastYscale, TRUE, TRUE, s_HBOff);
	p_lblFastYscale->show ();
	d_cbFastYscale.set_active (TRUE);
	p_hb3_2->pack_start (d_cbFastYscale, TRUE, TRUE, s_HBOff);
	d_cbFastYscale.show ();
	p_vb3->pack_start (*p_hb3_2, TRUE, TRUE, s_VBOff);
	p_hb3_2->show ();

	p_lblFastZrot->set_justify (GTK_JUSTIFY_LEFT);
	p_hb3_3->pack_start (*p_lblFastZrot, TRUE, TRUE, s_HBOff);
	p_lblFastZrot->show ();
	d_cbFastZrot.set_active (FALSE);
	p_hb3_3->pack_start (d_cbFastZrot, TRUE, TRUE, s_HBOff);
	d_cbFastZrot.show ();
	p_vb3->pack_start (*p_hb3_3, TRUE, TRUE, s_VBOff);
	p_hb3_3->show ();

	d_frame3.add (p_vb3);
	p_vb3->show ();
	d_frame3.show ();

}


/*
 *  buildPOVOptionsFrame: build the frame for the Export->POV menu options
 */
void TFDialogOptions::buildPOVOptionsFrame ()
{
	p_lblPOVfileName->set_justify (GTK_JUSTIFY_LEFT);
	p_hb4_1->pack_start (*p_lblPOVfileName, TRUE, TRUE, s_HBOff);
	p_lblPOVfileName->show ();
	d_enPOVfile.set_text (TFOptions::s_POVfile);
	p_hb4_1->pack_start (d_enPOVfile, TRUE, TRUE, s_HBOff);
	d_enPOVfile.show ();
	p_vb4->pack_start (*p_hb4_1, TRUE, TRUE, s_VBOff);
	p_hb4_1->show ();

	p_lblPOVwidth->set_justify (GTK_JUSTIFY_LEFT);
	p_hb4_2->pack_start (*p_lblPOVwidth, TRUE, TRUE, s_HBOff);
	p_lblPOVwidth->show ();
	p_adjPOVwidth->set_value (400);
	p_hb4_2->pack_start (*p_hsPOVwidth, TRUE, TRUE, s_HBOff);
        p_hsPOVwidth->set_digits (0);
	p_hsPOVwidth->show ();
	p_vb4->pack_start (*p_hb4_2, TRUE, TRUE, s_VBOff);
	p_hb4_2->show ();

	p_lblPOVyscale->set_justify (GTK_JUSTIFY_LEFT);
	p_hb4_3->pack_start (*p_lblPOVyscale, TRUE, TRUE, s_HBOff);
	p_lblPOVyscale->show ();
	d_cbPOVhalfYscale.set_active (TRUE);
	p_hb4_3->pack_start (d_cbPOVhalfYscale, TRUE, TRUE, s_HBOff);
	d_cbPOVhalfYscale.show ();
	p_vb4->pack_start (*p_hb4_3, TRUE, TRUE, s_VBOff);
	p_hb4_3->show ();

	p_lblPOVkeepFiles->set_justify (GTK_JUSTIFY_LEFT);
	p_hb4_4->pack_start (*p_lblPOVkeepFiles, TRUE, TRUE, s_HBOff);
	p_lblPOVkeepFiles->show ();
	d_cbPOVkeepFiles.set_active (FALSE);
	p_hb4_4->pack_start (d_cbPOVkeepFiles, TRUE, TRUE, s_HBOff);
	d_cbPOVkeepFiles.show ();
	p_vb4->pack_start (*p_hb4_4, TRUE, TRUE, s_VBOff);
	p_hb4_4->show ();

	d_frame4.add (p_vb4);
	p_vb4->show ();
	d_frame4.show ();

}


/*
 *  getValues: get all the values from the dialog inputs
 */
void TFDialogOptions::getValues (bool *fillSea, bool *drawDerived, int *scale, 
				int *syncRate, int *resolution, float *yscale, 
				float *sealevel, bool *fastHalfRes, 
				bool *fastHalfYscale, bool *fastZrot)
{
	*fillSea = d_cbFillSea.get_active ();
	*drawDerived = d_cbDrawDerived.get_active ();
	*scale = (int)(p_adjScale->get_value ()); 
	*syncRate = (int)(p_adjSync->get_value());
	*resolution = (int)(p_adjResolution->get_value ()); 
	*yscale= p_adjYScale->get_value (); 
	*sealevel = p_adjSealevel->get_value (); 
	*fastHalfRes = d_cbFastResolution.get_active ();
	*fastHalfYscale = d_cbFastYscale.get_active ();
	*fastZrot = d_cbFastZrot.get_active ();
}


void TFDialogOptions::buttonCallbackOK ()
{	
	this->hide ();
	gdk_flush ();
	buttonCallbackApply ();
}


/*
 *  buttonCallbackApply: update what's been changed and redraw if necessary
 */
void TFDialogOptions::buttonCallbackApply ()
{
	bool			redraw=FALSE;

	int			scale, 
				syncRate;
	bool			fillSea,
				drawDerived,
				fastHalfRes,
				fastHalfYscale,
				fastZrot; 

	int			resolution;
	float			yscale, 
				sealevel;

	getValues (&fillSea, &drawDerived, &scale, &syncRate, &resolution, &yscale, &sealevel,
		   &fastHalfRes, &fastHalfYscale, &fastZrot);

	if (fillSea != TFOptions::s_fillSea)
		{
		TFOptions::s_fillSea = fillSea;
		redraw = TRUE;
		}

	if (drawDerived != TFOptions::s_drawDerivedData)
		{
		TFOptions::s_drawDerivedData = drawDerived;
		redraw = TRUE;
		}

	if (scale != TFOptions::s_scale)	
		{
		TFOptions::s_scale = scale;
		redraw = TRUE;
		}

	if (syncRate != TFOptions::s_syncRate)
		{
		TFOptions::s_syncRate = syncRate;
		redraw = TRUE;
		}

	if (resolution != TFOptions::s_resolution)
		{
		TFOptions::s_resolution = resolution;
		redraw = TRUE;
		}

	if (yscale != TFOptions::s_yscale)
		{
		TFOptions::s_yscale = yscale;
		redraw = TRUE;
		}

	if (sealevel != TFOptions::s_sealevel)
		{
		TFOptions::s_sealevel = sealevel;
		redraw = TRUE;
		}

	TFOptions::s_fastHalfRes = fastHalfRes;
	TFOptions::s_fastHalfYscale = fastHalfRes;
	TFOptions::s_fastZrot = fastZrot;

	strcpy (TFOptions::s_POVfile, d_enPOVfile.get_text().c_str());
	TFOptions::s_POVwidth = (int)(p_adjPOVwidth->get_value());
	TFOptions::s_POVhalfYscale = d_cbPOVhalfYscale.get_active();
	TFOptions::s_POVkeepFiles = d_cbPOVkeepFiles.get_active ();

	// now set the options for all TFWindowHandlers in the window list
	int		lim = d_wList->getSize ();
	// printf ("%d\n", lim);
	for (int i=0; i<lim; i++)
		{
		TFWindowHandler		*TFWH;
		HeightFieldDraw		*HFD;

		TFWH = static_cast<TFWindowHandler*>(d_wList->El(i));
		HFD = TFWH->getHeightFieldDraw ();
		HFD->updateParams ();
		HFD->setFastOptions (fastHalfRes, fastHalfYscale, fastZrot);
		if (redraw)
			HFD->draw ();
		}
}


gint TFDialogOptions::delete_event_impl (GdkEventAny *e)
{
	this->hide ();
	return (0);
}




