/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "TFDialogLinearScale.h"
#include "GlobalDefs.h"
#include "GlobalSanityCheck.h"
#include "GlobalTrace.h"
#include "GuiDialogOAC.h"
#include "MathTrig.h"


/*
 *  constructor: initialize all data members 
 */
TFDialogLinearScale::TFDialogLinearScale (HeightField *HF, HeightFieldDraw *HFD)
	        : TFPreviewDialog (HF, HFD, "Terraform Linear Scale Dialog", 
					"Parameters", 6, 8),
		  d_vbList (TRUE, 0),
		  d_hbCX (TRUE, 5),
		  d_hbCY (TRUE, 5),
		  d_hbScaleFactor (TRUE, 5),
		  d_hbMinDist (TRUE, 5),
		  d_hbMaxDist (TRUE, 5),
		  d_hbSmoothDist (TRUE, 5),
		  d_hbInvert (TRUE, 5),
		  d_hbFullDist (TRUE, 5),
		  d_frmOptions ("Linear Scale Options")
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ TFDialogLinearScale\n");

	p_lblCX = new Gtk_Label (_("Center X"));
	p_lblCY = new Gtk_Label (_("Center Y"));
	p_lblScaleFactor = new Gtk_Label (_("Scale Factor"));
	p_lblMinDist = new Gtk_Label (_("Scale Start Distance"));
	p_lblMaxDist = new Gtk_Label (_("Scale End Distance"));
	p_lblSmoothDist = new Gtk_Label (_("Smoothing Factor"));
	p_lblInvert = new Gtk_Label (_("Invert Scale Factor"));
	p_lblFullDist = new Gtk_Label (_("Scale against Max Distance"));

	p_adjCX = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjCY = new Gtk_Adjustment (0.5, 0, 1, 0.01);
	p_adjScaleFactor = new Gtk_Adjustment (1.5, 1, 5, 0.01);
	p_adjMinDist = new Gtk_Adjustment (0.33, 0, 1, 0.01);
	p_adjMaxDist = new Gtk_Adjustment (0.66, 0, 1, 0.01);
	p_adjSmoothDist = new Gtk_Adjustment (0.1, 0, 1, 0.01);

	p_hsCX = new Gtk_HScale (*p_adjCX);
	p_hsCY = new Gtk_HScale (*p_adjCY);
	p_hsScaleFactor = new Gtk_HScale (*p_adjScaleFactor);
	p_hsMinDist = new Gtk_HScale (*p_adjMinDist);
	p_hsMaxDist = new Gtk_HScale (*p_adjMaxDist);
	p_hsSmoothDist = new Gtk_HScale (*p_adjSmoothDist);

	buildDialogWindow ();
	this->setHFobjs (HF, HFD);
	sprintf (this->p_windowTitle, _("Linear Scale: %s"), p_HF->getName());
	this->set_title (this->p_windowTitle);
	this->iterateEvents ();
	updatePreviewCallback ();

	connect_to_method (p_adjCX->value_changed, this, &TFDialogLinearScale::updatePreviewCallback);
	connect_to_method (p_adjCY->value_changed, this, &TFDialogLinearScale::updatePreviewCallback);
	connect_to_method (p_adjMinDist->value_changed, this, &TFDialogLinearScale::updatePreviewCallback);
	connect_to_method (p_adjMaxDist->value_changed, this, &TFDialogLinearScale::updatePreviewCallback);
	connect_to_method (p_adjScaleFactor->value_changed, this, &TFDialogLinearScale::updatePreviewCallback);
	connect_to_method (p_adjSmoothDist->value_changed, this, &TFDialogLinearScale::updatePreviewCallback);
	connect_to_method (d_btnInvert.clicked, this, &TFDialogLinearScale::updatePreviewCallback);
	connect_to_method (d_btnFullDist.clicked, this, &TFDialogLinearScale::updatePreviewCallback);
}


/*
 *  destructor: clean up 
 */
TFDialogLinearScale::~TFDialogLinearScale ()
{
	delete p_lblCX;
	delete p_lblCY;
	delete p_lblScaleFactor;
	delete p_lblMinDist;
	delete p_lblMaxDist;
	delete p_lblSmoothDist;
	delete p_lblInvert;
	delete p_lblFullDist;

	delete p_adjCX;
	delete p_adjCY;
	delete p_adjScaleFactor;
	delete p_adjMinDist;
	delete p_adjMaxDist;
	delete p_adjSmoothDist;

	delete p_hsCX;
	delete p_hsCY;
	delete p_hsScaleFactor;
	delete p_hsMinDist;
	delete p_hsMaxDist;
	delete p_hsSmoothDist;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- TFDialogLinearScale\n");
}


/*
 *  insertOptions: fill the dialog's VBox
 */
void TFDialogLinearScale::insertOptions ()
{
	d_frmOptions.set_shadow_type (GTK_SHADOW_ETCHED_IN);
	d_frmOptions.set_border_width (5);

	d_hbCX.pack_start (*p_lblCX, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblCX->show ();
	p_hsCX->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsCX->set_digits (2);
	p_hsCX->set_draw_value (TRUE);
	d_hbCX.pack_end (*p_hsCX, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsCX->show ();
	d_vbList.pack_start (d_hbCX, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbCX.show ();

	d_hbCY.pack_start (*p_lblCY, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblCY->show ();
	p_hsCY->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsCY->set_digits (2);
	p_hsCY->set_draw_value (TRUE);
	d_hbCY.pack_end (*p_hsCY, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsCY->show ();
	d_vbList.pack_start (d_hbCY, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbCY.show ();

	d_hbMinDist.pack_start (*p_lblMinDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblMinDist->show ();
	p_hsMinDist->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsMinDist->set_digits (2);
	p_hsMinDist->set_draw_value (TRUE);
	d_hbMinDist.pack_end (*p_hsMinDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsMinDist->show ();
	d_vbList.pack_start (d_hbMinDist, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbMinDist.show ();

	d_hbMaxDist.pack_start (*p_lblMaxDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblMaxDist->show ();
	p_hsMaxDist->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsMaxDist->set_digits (2);
	p_hsMaxDist->set_draw_value (TRUE);
	d_hbMaxDist.pack_end (*p_hsMaxDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsMaxDist->show ();
	d_vbList.pack_start (d_hbMaxDist, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbMaxDist.show ();

	d_vbList.pack_start (d_hSep);
	d_hSep.show ();

	d_hbScaleFactor.pack_start (*p_lblScaleFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblScaleFactor->show ();
	p_hsScaleFactor->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsScaleFactor->set_digits (2);
	p_hsScaleFactor->set_draw_value (TRUE);
	d_hbScaleFactor.pack_end (*p_hsScaleFactor, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsScaleFactor->show ();
	d_vbList.pack_start (d_hbScaleFactor, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbScaleFactor.show ();

	d_hbSmoothDist.pack_start (*p_lblSmoothDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblSmoothDist->show ();
	p_hsSmoothDist->set_update_policy (GTK_UPDATE_CONTINUOUS);
	p_hsSmoothDist->set_digits (2);
	p_hsSmoothDist->set_draw_value (TRUE);
	d_hbSmoothDist.pack_end (*p_hsSmoothDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_hsSmoothDist->show ();
	d_vbList.pack_start (d_hbSmoothDist, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbSmoothDist.show ();

	d_hbInvert.pack_start (*p_lblInvert, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblInvert->show ();
	d_hbInvert.pack_end (d_btnInvert, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_btnInvert.show ();
	d_vbList.pack_start (d_hbInvert, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbInvert.show ();

	d_hbFullDist.pack_start (*p_lblFullDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	p_lblFullDist->show ();
	d_hbFullDist.pack_end (d_btnFullDist, TRUE, TRUE, GuiDialogOAC::s_HBOff);
	d_btnFullDist.show ();
	d_vbList.pack_start (d_hbFullDist, TRUE, TRUE, GuiDialogOAC::s_VBOff);
	d_hbFullDist.show ();

	d_frmOptions.add (d_vbList);
	this->p_tblMain->attach (d_frmOptions, 3, 6, 1, 7);
        d_vbList.show ();
	d_frmOptions.show ();
        this->p_frmBase->show ();
        this->get_vbox()->show ();
}



void TFDialogLinearScale::buildDialogWindow ()
{
	this->set_usize (450, 375);
	this->set_title (this->p_windowTitle);

	this->get_vbox()->set_border_width (2);

	this->setupVBox ();
	this->insertPreview ();
	insertOptions ();
	this->fillActionArea ();

	connect_to_method (p_drawArea->button_press_event, this, 
			&TFDialogLinearScale::daButtonPressedCallback);
	
	this->show ();
}


/*
 *  buttonCallbackApply: roughen the Height Field
 */
void TFDialogLinearScale::buttonCallbackApply ()
{
	float			cx, cy, sf, mind, maxd, smoothf;
	bool			invert, fulldist;

	cx = p_adjCX->get_value ();
	cy = p_adjCY->get_value ();
        sf = p_adjScaleFactor->get_value ();
        mind = p_adjMinDist->get_value (); 
	maxd = p_adjMaxDist->get_value ();
	smoothf = p_adjSmoothDist->get_value ();
	invert = d_btnInvert.get_active ();
	fulldist = d_btnFullDist.get_active ();

	if (invert)
		sf = 1-(sf-1);

	SanityCheck::bailout ((!p_HFO), "p_HFO==NULL", "TFDialogLinearScale::buttonCallbackApply");
	p_HFO->linearScale (cx, cy, sf, mind, maxd, smoothf, invert, fulldist);
	p_HFD->draw ();

	// only do this if window stays open 
	if (b_applyHit)
		{
		this->setHFobjs (p_HF, p_HFD);
		updatePreviewCallback ();
		}

	this->b_applyHit = TRUE;
}


/*
 *  updatePreviewCallback: update the preview after a slider has been updated.
 */
void TFDialogLinearScale::updatePreviewCallback ()
{
	if (!d_cbUsePreview.get_active())
		return;

	float		cx, cy, sf, mind, maxd, smoothf;
	bool		invert, fulldist;

	cx = p_adjCX->get_value ();
	cy = p_adjCY->get_value ();
        sf = p_adjScaleFactor->get_value ();
        mind = p_adjMinDist->get_value (); 
	maxd = p_adjMaxDist->get_value ();
	smoothf = p_adjSmoothDist->get_value ();
	invert = d_btnInvert.get_active ();
	fulldist = d_btnFullDist.get_active ();

	if (invert)
		sf = 1-(sf-1);

	SanityCheck::bailout ((!p_HFPreview), "p_HFPreview==NULL", "TFDialogLinearScale::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFOPreview), "p_HFOPreview==NULL", "TFDialogLinearScale::updatePreviewCallback");
	SanityCheck::bailout ((!p_HFDPreview), "p_HFOPreview==NULL", "TFDialogLinearScale::updatePreviewCallback");
	this->previewUpToDate ();
	p_HFPreview->restoreBackup ();
	p_HFOPreview->linearScale (cx, cy, sf, mind, maxd, smoothf, invert, fulldist);
	p_HFDPreview->setColormap (p_HFD->getColormap());
	p_HFDPreview->draw ();
	d_cx = (int)(cx*(float)p_drawArea->width()); 
	d_cy = (int)(cy*(float)p_drawArea->height()); 
	this->drawCrosshairs (d_cx, d_cy);
}


/*
 *  daButtonPressedCallback: update the preview p_drawArea and adjustment 
 * 	the appropriate widgets (done when the user clicks on the preview)
 */
int TFDialogLinearScale::daButtonPressedCallback (GdkEventButton *e)
{
	if (!d_cbUsePreview.get_active())
		return 1;

	int	w = this->p_drawArea->width(),
		h = this->p_drawArea->height();

	if (e->button == 1)
		{
		p_adjCX->set_value (e->x/w);
		p_adjCY->set_value (e->y/h);
		}
	else
	if (e->button == 2)
		{
		float	d = MathTrig::distance (p_adjCX->get_value()*w, 
				p_adjCY->get_value()*h, e->x, e->y);

		d/=((p_drawArea->width()+p_drawArea->height())/2);
		if (d > 1)
			d=1;
		p_adjMinDist->set_value (d); 
		}
	else
	if (e->button == 3)
		{
		float	d = MathTrig::distance (p_adjCX->get_value()*w, 
				p_adjCY->get_value()*h, e->x, e->y);

		d/=((p_drawArea->width()+p_drawArea->height())/2);
		if (d > 1)
			d=1;
		p_adjMaxDist->set_value (d); 
		}
	updatePreviewCallback ();
	return 0;
}

