/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_GEN_SUBDIV_H
#define _TF_DIALOG_GEN_SUBDIV_H 1


#include "GuiDialogOAC.h"				// include gtk. gtk--
#include "TFWindowHandler.h"


#define MENU_GEN_DIAMOND        "Diamond Square"
#define MENU_GEN_MIDPOINT       "Midpoint Subdivision"
#define MENU_GEN_OFFSET         "Offset Square"
#define MENU_GEN_RECURSIVE      "Recursive Subdivision"



/*
 *  TFDialogGenSubdiv: display the d options dialog for terraformer
 */
class TFDialogGenSubdiv : public GuiDialogOAC
	{
	public: 
				TFDialogGenSubdiv ();
				~TFDialogGenSubdiv (); 
		void		reset ();
		void		seedCornersCheckboxCallback ();
		void		seedCheckboxCallback ();
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();

	private:
		void		fillVBox ();
		gint 		delete_event_impl (GdkEventAny *);

		int			d_mode;
		Gtk_VBox		d_vbList;
		Gtk_HBox		d_hbMethod, d_hbSize, d_hbScaleFactor, 
					d_hbGenSeed, d_hbSeed;
		Gtk_CheckButton		d_btnGenSeed;
		Gtk_Entry		d_enSeed;
		Gtk_HSeparator		d_sepMain;
		Gtk_Combo		*p_cmbMethod;
		Gtk_Label		*p_lblMethod, *p_lblSize, *p_lblScaleFactor, 
					*p_lblGenSeed, *p_lblSeed;
		Gtk_Adjustment		*p_adjScaleFactor, *p_adjSize;
		Gtk_HScale		*p_hsScaleFactor, *p_hsSize;
		GList			*p_glstMethod;
		char			*p_seedInitStr;
		HeightField		*p_HF;
		TFWindowHandler		*p_tfWin;
	};


#endif // _TF_DIALOG_GEN_SUBDIV_H
