/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_GAUSSIAN_HILL_H
#define _TF_DIALOG_GAUSSIAN_HILL_H 1


#include "TFPreviewDialog.h"				// include gtk, gtk--



/*
 *  TFDialogGaussianHill: display the roughen dialog for terraformer
 */
class TFDialogGaussianHill : public TFPreviewDialog  
	{
	public: 
				TFDialogGaussianHill (HeightField *HF, HeightFieldDraw *HFD);
				~TFDialogGaussianHill (); 
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();

	private:
		void		insertOptions ();
		void		updatePreviewCallback ();
		int		daButtonPressedCallback (GdkEventButton *event);

		Gtk_VBox		d_vbList;
		Gtk_HBox		d_hbCX, d_hbCY, 
					d_hbRadius, d_hbScaleFactor, 
					d_hbRadFac, d_hbSmoothFactor,
					d_hbDeltaScale;
		Gtk_Frame		d_frmOptions;
		Gtk_HSeparator		d_hSep;
		Gtk_Adjustment		*p_adjCX, *p_adjCY,
					*p_adjRadius, *p_adjScaleFactor, 
					*p_adjRadFac, *p_adjSmoothFactor, 
					*p_adjDeltaScale;
		Gtk_HScale		*p_hsCX, *p_hsCY, 
					*p_hsRadius, *p_hsScaleFactor, 
					*p_hsRadFac, *p_hsSmoothFactor,
					*p_hsDeltaScale;
		Gtk_Label		*p_lblCX, *p_lblCY,
					*p_lblRadius, *p_lblScaleFactor, 
					*p_lblRadFac, *p_lblSmoothFactor, 
					*p_lblDeltaScale;
	};


#endif // _TF_DIALOG_GAUSSIAN_HILL_H
