/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_ERODE_H
#define _TF_DIALOG_ERODE_H 1


#include "TFBaseDialog.h"


/*
 *  TFDialogErode: display the rotate dialog for terraformer
 */
class TFDialogErode : public TFBaseDialog
	{
	public: 
				TFDialogErode (HeightField *HF, HeightFieldDraw *HFD);
				~TFDialogErode (); 
		void 		checkboxCallback ();
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();

	private:
		void		buildErodeFrame ();
		void		buildFlowmapFrame ();
		void		fillVBox ();

		Gtk_VBox		d_vbList1,
					d_vbList2;
		Gtk_HBox		d_hbHS1, 
					d_hbHS2, 	
					d_hbHS3, 	
					d_hbSave,
					d_hbTrim;
		Gtk_Frame		d_frm1,	
					d_frm2;
		Gtk_Adjustment		d_adjNTurns,
					d_adjMaxElvErode, 
					d_adjMaxFlowAge; 
		Gtk_HScale		d_hsNTurns,
					d_hsMaxElvErode, 
					d_hsMaxFlowAge;
		Gtk_Label		d_lblHS1,
					d_lblHS2, 
					d_lblHS3, 
					d_lblSave, 
					d_lblTrim;
		Gtk_Entry		d_entFileName;
		Gtk_HSeparator		d_hSep;
		GSList 			*p_group;
		Gtk_RadioButton		*p_RB1, *p_RB2;
		Gtk_CheckButton		*p_cbSealevel,
					*p_cbSave, 
					*p_cbTrim;
	};


#endif // _TF_DIALOG_ERODE_H
