/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _TF_DIALOG_CRATERS_H
#define _TF_DIALOG_CRATERS_H 1


#include "TFPreviewDialog.h"				// include gtk, gtk--



/*
 *  TFDialogCraters: display the roughen dialog for terraformer
 */
class TFDialogCraters : public TFPreviewDialog  
	{
	public: 
				TFDialogCraters (HeightField *HF, HeightFieldDraw *HFD);
				~TFDialogCraters (); 
		void		buildDialogWindow ();
		void 		buttonCallbackApply ();
		void		seedCheckboxCallback ();
		void		checkboxCallbackPreview ();

	private:
		void		insertOptions ();
		void		updatePreviewCallback ();
		void		adjNumCratersCallback ();
		int			daButtonPressedCallback (GdkEventButton *event);

		Gtk_VBox		d_vbList;
		Gtk_HBox		d_hbCX, d_hbCY, d_hbNumCraters,
					d_hbRadius, d_hbHeight, 
					d_hbCraterCoverage, d_hbWrap, 
					d_hbGenSeed, d_hbSeed;
		Gtk_CheckButton		d_btnWrap,
					d_btnGenSeed;
		Gtk_Entry		d_enSeed;
		Gtk_Frame		d_frmOptions;
		Gtk_HSeparator		d_hSep, 
					d_hSepSeed;
		int			d_lastPreviewSeed;
		char			*p_seedInitStr;
		Gtk_Adjustment		*p_adjCX, *p_adjCY, *p_adjNumCraters,
					*p_adjRadius, *p_adjHeight, *p_adjCraterCoverage; 
		Gtk_HScale		*p_hsCX, *p_hsCY, *p_hsNumCraters,
					*p_hsRadius, *p_hsHeight, *p_hsCraterCoverage; 
		Gtk_Label		*p_lblCX, *p_lblCY, *p_lblNumCraters,
					*p_lblRadius, *p_lblHeight, 
					*p_lblCraterCoverage, *p_lblWrap, 
					*p_lblGenSeed, *p_lblSeed;
	};


#endif // _TF_DIALOG_CRATERS_H
