/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _RENDER_OPTIONS_H
#define _RENDER_OPTIONS_H 1


#include "GlobalDefs.h"

// levels 0, 1, 2, 3
#define LIGHTING_PLASTIC	"Plastic Model"
#define LIGHTING_REALSKY	"Real Sky"
#define LIGHTING_SUNBEAMS_FAST	"Real Sky with Sunbeams (Fast)"
#define LIGHTING_SUNBEAMS_SLOW	"Real Sky with Sunbeams (Slow)"


/*
 *  RenderOptions: options used exclusively for photorealistic rendering. 
 * 	This class should be instantiated for every height field.
 */
class RenderOptions 
	{
	public:
				RenderOptions (char *HFfilename);
				~RenderOptions ();
		int		writePOVFile (char *fname);

		// accessors
		bool		getSmooth ();
		bool		getHalfYScale ();
		bool		getKeepFiles ();
		bool		getHaveClouds ();
		bool		getHaveFog ();
		void 		getSize (UI *width, UI *height);
		UI		getLightingLevel ();
		//UI		getPOVquality ();
		float		getSealevel ();
		float		getWaterClarity ();
		float		getTimeOfDay ();
		float		getNorthDir ();
		void		getCameraLocation (float *x, float *y, float *z);
		void		getLookAtLocation (float *x, float *y, float *z);
		char		*getPOVFile ();
		char		*getHFFile ();

		// mutators
		void		setSmooth (bool smooth);
		void		setHalfYScale (bool halfYScale);
		void		setKeepFiles (bool keepFiles);
		void		setHaveClouds (bool haveClouds);
		void		setHaveFog (bool haveFog);
		void 		setSize (UI width, UI height=0);
		void 		setLightingLevel (UI lightLevel);
		//void 		setPOVquality (UI quality);
		void 		setSealevel (float sealevel);
		void		setWaterClarity (float clarity);
		void		setTimeOfDay (float timeOfDay);
		void		setNorthDir (float northDir);
		void		setCameraLocation (float x, float y, float z);
		void		setLookAtLocation (float x, float y, float z);
		void		setPOVFile (char *filename);
		void		setHFFile (char *filename);

	private: 
		bool		b_smooth,	// do we smooth the terrain
				b_halfYScale,	// do we half the y scale when rendering 
				b_keepFiles,	// do we keep files in the local dir or use /tmp
				b_haveClouds,	// do we have clouds in the sky 
				b_haveFog,	// do we have fog
				b_haveWater;	// copy of TFOptions::fillSea

		UI 		d_width,	// width of rendering
				d_height,	// height of rendering
				d_lightingLevel,// the lighting level we render with 
				d_POVquality;	// height of rendering, unused

		float 		d_seaLevel,	// copy of TFOptions::s_sealevel
				d_waterClarity,	// clarity of water: 0 .. 1
				d_timeOfDay,	// time (used for lighting)
				d_northDir,	// direction which is North
				d_cameraX,	// X
				d_cameraY,	// Y
				d_cameraZ,	// Z for the camera location
				d_lookAtX,	// X
				d_lookAtY,	// Y
				d_lookAtZ;	// Z for the point we look at

		char 		*p_POVfile,	// the POV file we use to render the scene
				*p_HFfile;	// the POV file we use to render the scene
	};


#endif // _RENDER_OPTIONS_H
