/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_IO_H
#define _HEIGHT_FIELD_IO_H


#include "FileIO.h"
#include "HeightField.h"
#include "HeightFieldDraw.h"
#include "HeightFieldReader.h"
#include "HeightFieldWriter.h"


// file types 
#define PGM	0		// PGM ascii type (arbitrary) 
#define TGA	1		// POV-Ray 2.2 TGA heightfield format 16-bit
#define PNG	2		// PNG format (not yet supported)
#define PG8 	3		// binary PGM format 8-bit
#define OCT	4		// Octave ascii format (arbitrary)
#define MAT	5		// Matlab Level 1.0 binary format 32bit float
#define GIF	6		// CompuServe (tm) GIF format 8-bit 
#define POT	7		// Fractint, PoV-Ray "continuous potential" 16-bit 
#define RAW	8		// RAW ascii format triangle vertices (x,y,z) 
#define DEM	9		// DEM file format
#define GTP	10		// GTOPO30 file format
#define TIFF 	11		// TIFF file format
#define BMP	12		// Windows & OS/2 BMP format
#define AC	13		// ACAD 3D modeller; exports a triangle map


// defs for MATLAB file format
#ifdef BIG_ENDIAN
#define NUM_FMT 1
#else
#define NUM_FMT 0       	// 0 IEEE Little Endian (80x86, DEC Risc) 
#endif                  	// 1 IEEE Big Endian (SPARC, SGI, Motorola, etc.) 

#define PREC	1		// storing Matlab file as floats rather than longs 
typedef struct { 		// Matlab Level 1.0 format data file header 
        long type;      	// type 
        long mrows;     	// row dimension 
        long ncols;     	// column dimension 
        long imagf;     	// flag indicating imag part
        long namelen;    	// name length (including NULL) 
} Fmatrix;


// defs for Oct file format
#define ARRAY_SIZE  16384 	// set (Max) line size
#define STRING_SIZE  16384	// set (Max) string size 
#define NAME_SIZE       20

#define OCT_NAME      "name:"
#define OCT_TYPE      "type:"
#define OCT_ROWS      "rows:"
#define OCT_COLUMNS   "columns:"

#define META_DATA_CHARACTER '#'

#define NUM_LINES_READ   4

typedef enum OctInputFlags
{
	OCT_None	= 0,
	OCT_Name	= 1,
	OCT_Type	= 2,
	OCT_Rows 	= 4,
	OCT_Columns	= 8
} OCT_OIF;



// defs for BMP format
#define MAXCOLORS       256
#define Image		gint32
#define BitSet(byte, bit)  (((byte) & (bit)) == (bit))

#define ReadOK(file,buffer,len)  (fread(buffer, len, 1, file) != 0)
#define Write(file,buffer,len)   fwrite(buffer, len, 1, file)
#define WriteOK(file,buffer,len) (Write(buffer, len, file) != 0)

extern struct Bitmap_File_Head_Struct
  {
    unsigned long bfSize;		/* 02 */
    unsigned long reserverd;		/* 06 */
    unsigned long bfOffs;		/* 0A */
    unsigned long biSize;		/* 0E */
  }Bitmap_File_Head;

extern struct Bitmap_Head_Struct
  {   
    unsigned long biWidth;		/* 12 */
    unsigned long biHeight;		/* 16 */
    unsigned short biPlanes;            /* 1A */
    unsigned short biBitCnt;	        /* 1C */
    unsigned long biCompr;		/* 1E */
    unsigned long biSizeIm;		/* 22 */
    unsigned long biXPels;		/* 26 */
    unsigned long biYPels;		/* 2A */
    unsigned long biClrUsed;		/* 2E */
    unsigned long biClrImp;		/* 32 */
    					/* 36 */
  }Bitmap_Head;
  
extern struct Bitmap_OS2_Head_Struct
  {   
    unsigned short bcWidth;             /* 12 */
    unsigned short bcHeight;	        /* 14 */
    unsigned short bcPlanes;            /* 16 */
    unsigned short bcBitCnt;	        /* 18 */
  }Bitmap_OS2_Head;                


/*
 *  HeightFieldIO: IO handling class for Height Fields 
 */
class HeightFieldIO:public FileIO
	{
	public:
				HeightFieldIO (const char *fName);
				~HeightFieldIO ();
		int		read (HeightField *HF);
		int		write (HeightField *HF, HeightFieldDraw *HFD=NULL);
		int		getFileType ();		// determine file type
	};


#endif // _HEIGHT_FIELD_IO_H

