/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_EXPORT_H
#define _HEIGHT_FIELD_EXPORT_H


#include "HeightField.h"
#include "HeightFieldOps.h"
#include "tf_glistFlexArr.h"


/*
 *  HeightFieldExport: class for various export formats for a height field
 */
class HeightFieldExport
	{
	public:
				HeightFieldExport (HeightField *HF);
				~HeightFieldExport();

		void		printContourLines (TFGListFlexArr *listMain, HeightFieldDraw *HFD);
		void		exportContourLinesToPS (TFGListFlexArr *listMain, HeightFieldDraw *HFD, char *fname);
		int		renderPOV ();

	private:

		HeightField		*p_HF;
	};


#endif // _HEIGHT_FIELD_EXPORT_H 

