/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <string.h>
#include <stdlib.h>
#include "GuiDialogYN.h"
#include "GlobalTrace.h"



/*
 *  constructor: initialize everything 
 */
GuiDialogYN::GuiDialogYN(char *winTitle, char *frameTitle, char type)
	      : Gtk_Dialog (),
		d_btnYes (type=='Y' ? "Yes" : "OK"),
		d_btnNo (type=='Y' ? "No" : "Cancel")
{
	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "+++ GuiDialogYN\n");

	if (winTitle)
		p_windowTitle = strdup (winTitle);
	else
		p_windowTitle = strdup ("GuiDialogYN Window");

	if (frameTitle)
		p_frameTitle = strdup (frameTitle);
	else
		p_frameTitle = NULL;

	p_frmBase = NULL;
	this->set_position (GTK_WIN_POS_MOUSE);		
}


/*
 *  destructor: clean up, free allocated memory
 */
GuiDialogYN::~GuiDialogYN()
{
	if (p_windowTitle) free (p_windowTitle);	// c-type alloc from strdup
	if (p_frameTitle) free (p_frameTitle);	// c-type alloc from strdup
	if (p_frmBase) delete p_frmBase;

	GlobalTrace::trace (GlobalTrace::TRACE_FLOW, "--- GuiDialogYN\n");
}


/*
 *  (virtual) buildDialogWindow: call the proper functions to setup the dialog
 */
void GuiDialogYN::buildDialogWindow ()
{
	this->set_usize (300, 120);
	this->set_title (p_windowTitle);

	this->get_vbox()->set_border_width (2);

	setupVBox ();
	fillVBox ();
	fillActionArea ();

	this->show ();
}


/*
 *  setupVBox: setup the basic frame of the vbox if necessary 
 */
void GuiDialogYN::setupVBox ()
{
	if (p_frameTitle)
		{
		p_frmBase = new Gtk_Frame (p_frameTitle);
		p_frmBase->set_shadow_type (GTK_SHADOW_ETCHED_IN);
		p_frmBase->set_border_width (6);
		this->get_vbox()->pack_start (*p_frmBase, TRUE, TRUE, 0);
		p_frmBase->show ();	
		}
	this->get_vbox()->show ();
}


/*
 *  (virtual) fillVBox: fill the dialog's VBox 
 */
void GuiDialogYN::fillVBox ()
{
}


/*
 *  fillActionArea: fill the dialog's action area 
 */
void GuiDialogYN::fillActionArea ()
{
	connect_to_method (d_btnYes.clicked, this, &GuiDialogYN::buttonCallbackYes);
	this->get_action_area()->pack_start (d_btnYes, TRUE, TRUE, 0);
	d_btnYes.show ();

	connect_to_method (d_btnNo.clicked, this, &GuiDialogYN::buttonCallbackNo);
	this->get_action_area()->pack_start (d_btnNo, TRUE, TRUE, 0);
	d_btnNo.show ();
}


/*
 *  (virtual) buttonCallbackYes: process the Yes button press
 */
void GuiDialogYN::buttonCallbackYes ()
{
	cout << "GuiDialogYN: Default Callback Yes\n";
}


/*
 *  (virtual) buttonCallbackNo: process the No button press
 */
void GuiDialogYN::buttonCallbackNo ()
{
	cout << "GuiDialogYN: Default Callback No\n";
	this->hide ();
}


/*
 *  (virtual) delete_event_impl: provide delete event implementation
 */
gint GuiDialogYN::delete_event_impl(GdkEventAny *e)
{
	this->hide ();
	return (0);
}

