/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h> 
#include "GlobalDefs.h"
#include "GlobalTrace.h"


//int GlobalTrace::s_traceLevel=255;	// instantiate static data member 


/* 
 *  write: write s to the current trace output(s)
 */ 
bool GlobalTrace::trace (int traceLevel, char *s)
{
	if (s_traceLevel == TRACE_OFF)
		return 0;

	if (!s)
		return -1;

	if (GlobalTrace::isSet(traceLevel))
		{
		fprintf (stdout, "%s", s);
		fflush (stdout);
		return (TRUE);
		}
	return (FALSE);
}


/* 
 *  setTraceLevel: set the desired trace level (performs a range check)
 */ 
void GlobalTrace::setTraceLevel (int traceLevel)
{
	if (traceLevel >= 0 || traceLevel <= MAX_TRACELEVEL)
		{
		s_traceLevel = traceLevel;
		cout << "GlobalTrace::setTraceLevel: s_traceLevel = " << s_traceLevel << "\n";
		}
	else
		{
		cout << "Sanity Check Failed: GlobalTrace::setTraceLevel (tracelevel > " << MAX_TRACELEVEL << "\n";
		exit (1);
		}
}


/* 
 * getTraceLevel: return the current trace level
 */
int GlobalTrace::getTraceLevel ()
{
	return (s_traceLevel);
}


/*
 * isSet: check if the specified trace level is set  
 */ 
bool GlobalTrace::isSet (int traceLevel)
{
	if (traceLevel & s_traceLevel)
		return (TRUE);
	else
		return (FALSE);
}

