/***************************************************************************
                          rfilegbx.cpp  -  description
                             -------------------
    begin                : Tue Nov 9 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : mustun@ribbonsoft.com
 ***************************************************************************/



#include "rfilegbx.h"

#include "rmath.h"
#include "rstring.h"

#include <ctype.h>



// Constructor:
//
RFileGbx::RFileGbx(const char* _name, RGraphic* _graphic)
  :RFileBase(_name)
{
  graphic=_graphic;
}



// Destructor:
//
RFileGbx::~RFileGbx()
{

}



// load a cxf file (read in buffer / read from buffer):
//
bool
RFileGbx::load()
{
  if(readFileInBuffer()) {
    seperateBuf();
    return readFromBuffer();
  }
  else {
    return false;
  }
}



// read a cxf file from buffer:
//
bool
RFileGbx::readFromBuffer()
{
  char*     gerLine=0;
  char*     gerCode;                // Pointer to current code pos
  //int       vc=0;

  bool      prgEnd=false;           // End of program reached (M02)
  bool      readNextLine=true;      // Read next line or take this again?
  bool      noData;                 // Line contains no relevant data

  float     factor=0.0001;          // Factor mm
  //float     factor=0.0025;        // Factor  inch
  float     toolFactor=1.0;         // Factor for tool mreasures

  int       dOrder=0;               // M-Order (2=Prg End)
  int       gOrder=1;               // G-Order (0, 1, 2, 3, ...)
  float     xOrder=DEF_AREAMAX;     // X-Order (Coordinate)
  float     yOrder=DEF_AREAMAX;     // Y-Order (Coordinate)
  float     iOrder=DEF_AREAMAX;     // I-Order (Coordinate)
  float     jOrder=DEF_AREAMAX;     // J-Order (Coordinate)

  bool      xChange;                // x changed in this line
  bool      yChange;                // y changed in this line
  bool      iChange;                // i changed in this line
  bool      jChange;                // j changed in this line

  bool      relMode=false;          // Mode relativ

  float     currentX, currentY;     // current position

  float     vcx=0.0, vcy=0.0;       // Centre
  float     vcr=0.0;                // Radius
  float     va1, va2;               // Start / End Angle

  //byte      vlay;                   // Layer for elements

  char      add[16];                // Code for tool ("ADD")
  int       toolCount;              // counter for tools

  //float     pcFact;                 // Percentage-factor (progress bar)
  //int       updProgress=0;          // Update progress bar if this counter is 100

  int       currentLayerNum=0;      // Current layer number

  //if(vElements>0) pcFact = 75.0/(float)vElements;
  //else            pcFact = 100.0;

  graphic->clearLayers();

  graphic->addLayer(DEF_DEFAULTLAYER);

  resetBufP();

  //statusPanel()->iniProgress(fSize, RMES(292));

  currentX=0.0;
  currentY=0.0;

  if(fBuf) {

    // Reset tools:
    //
    for(toolCount=0; toolCount<GER_MAXTOOLS; ++toolCount) {
      gerTool[toolCount].x=0.0;
      gerTool[toolCount].y=0.0;
      gerTool[toolCount].shape=0;
    }

    // Read File:
    //
    do {
      if(readNextLine) {
        gerLine = getBufLine();
      }
      else {
        readNextLine=true;
      }

      if(gerLine) {

        xChange=false;
        yChange=false;
        iChange=false;
        jChange=false;
        noData=false;

        // Lines starting with '%':
        // no relevant datas:
        //
        if(gerLine[0]=='%') {

          // Read factor:
          //
          if(!strncmp((char*)gerLine, "%MOIN", 5)) {
            factor=0.0025;
            toolFactor=25.0;
          }

          // Read Tool:
          //
          sscanf((char*)gerLine, "%*[%%]%15[AD]", add);
          if(!strcmp(add, "ADD")) {
            int tNum=0;
            float tX=0.0, tY=0.0;
            char  tShape=0;

            sscanf((char*)gerLine, "%*[%%]%*[AD]%d%c", &tNum, &tShape);

            if(tNum<GER_MAXTOOLS) {

              // First value after ',':
              //
              gerCode=strchr((char*)gerLine, ',');
              if(gerCode) {
                ++gerCode;
                sscanf((char*)gerCode, "%f", &tX);
              }

              // Second value after 'X' or 'x':
              //
              gerCode=strchr((char*)gerLine, 'X');
              if(gerCode) {
                ++gerCode;
                sscanf((char*)gerCode, "%f", &tY);
              }
              gerCode=strchr((char*)gerLine, 'x');
              if(gerCode) {
                ++gerCode;
                sscanf((char*)gerCode, "%f", &tY);
              }

              gerTool[tNum].x = tX*toolFactor;
              gerTool[tNum].y = tY*toolFactor;
              gerTool[tNum].shape = tShape;
            }
          }
        }
        else {

          // D-Order:
          //
          gerCode=strchr((char*)gerLine, 'D');
          if(gerCode && isdigit(gerCode[1])) {
            ++gerCode;
            sscanf((char*)gerCode, "%d", &dOrder);

            switch(dOrder) {

              // Light on:
              //
              case 1:
                toolIsDown=true;
                break;

              // Light off:
              //
              case 2:
                toolIsDown=false;
                break;

              // Flash:
              //
              case 3:
                break;

              // Tool change:
              //
              default:
                if(dOrder<GER_MAXTOOLS) {
                  curTool.x=gerTool[dOrder].x;
                  curTool.y=gerTool[dOrder].y;
                  curTool.shape=gerTool[dOrder].shape;
                }
                toolIsDown=false;   // Light off after tool change
                break;
            }

          }

          // G-Order:
          //
          gerCode=strchr((char*)gerLine, 'G');
          if(gerCode && strIsValidNcOrderChar(gerCode[1])) {
            ++gerCode;
            int oriGOrder=gOrder;
            sscanf((char*)gerCode, "%d", &gOrder);

            // No relevant data:
            // G04 = Comment
            //
            if(gOrder==4) {
              noData=true;
            }

            if(gOrder>3) gOrder=oriGOrder;
          }


          if(readNextLine && !noData) {

            // X-Move:
            //
            gerCode=strchr((char*)gerLine, 'X');
            if(gerCode && strIsValidNcOrderChar(gerCode[1])) {
              ++gerCode;
              sscanf(gerCode, "%*[^0-9GXYIJ.-]%f", &xOrder);
              if(relMode) xOrder+=currentX;
              xChange=true;
            }

            // Y-Move:
            //
            gerCode=strchr((char*)gerLine, 'Y');
            if(gerCode && strIsValidNcOrderChar(gerCode[1])) {
              ++gerCode;
              sscanf((char*)gerCode, "%*[^0-9GXYIJ.-]%f", &yOrder);
              if(relMode) yOrder+=currentY;
              yChange=true;
            }

            // I-Move:
            //
            gerCode=strchr((char*)gerLine, 'I');
            if(gerCode && strIsValidNcOrderChar(gerCode[1])) {
              ++gerCode;
              sscanf((char*)gerCode, "%*[^0-9GXYIJ.-]%f", &iOrder);
              iChange=true;
            }

            // J-Move:
            //
            gerCode=strchr((char*)gerLine, 'J');
            if(gerCode && strIsValidNcOrderChar(gerCode[1])) {
              ++gerCode;
              sscanf((char*)gerCode, "%*[^0-9GXYIJ.-]%f", &jOrder);
              jChange=true;
            }

            if(xChange || yChange || iChange || jChange) {

              // -----
              // Move:
              // -----
              if(!toolIsDown) {
                currentX=xOrder;
                currentY=yOrder;
              }

              // ------
              // Flash:
              // ------
              if(dOrder==3) {
                switch(curTool.shape) {

                  // Round tool:
                  //
                  case 'C':
                  case 'c':
                    graphic->addCircle(xOrder*factor,
                                       yOrder*factor,
                                       curTool.x,
                                       0.0, 360.0,
                                       false, currentLayerNum);
                    break;

                  // Rectangular tool:
                  //
                  case 'R':
                  case 'r':
                    graphic->addLine((xOrder*factor-curTool.x/2.0),
                                            (yOrder*factor-curTool.y/2.0),
                                            (xOrder*factor-curTool.x/2.0),
                                            (yOrder*factor+curTool.y/2.0),
                                            currentLayerNum);

                    graphic->addLine((xOrder*factor-curTool.x/2.0),
                                            (yOrder*factor+curTool.y/2.0),
                                            (xOrder*factor+curTool.x/2.0),
                                            (yOrder*factor+curTool.y/2.0),
                                            currentLayerNum);

                    graphic->addLine((xOrder*factor+curTool.x/2.0),
                                            (yOrder*factor+curTool.y/2.0),
                                            (xOrder*factor+curTool.x/2.0),
                                            (yOrder*factor-curTool.y/2.0),
                                            currentLayerNum);

                    graphic->addLine((xOrder*factor+curTool.x/2.0),
                                            (yOrder*factor-curTool.y/2.0),
                                            (xOrder*factor-curTool.x/2.0),
                                            (yOrder*factor-curTool.y/2.0),
                                            currentLayerNum);
                    break;

                  // Oblong tool:
                  //
                  case 'O':
                  case 'o':
                    if(curTool.x<curTool.y) {
                      graphic->addLine((xOrder*factor-curTool.x/2.0),
                                              (yOrder*factor-curTool.y/2.0+curTool.x/2.0),
                                              (xOrder*factor-curTool.x/2.0),
                                              (yOrder*factor+curTool.y/2.0-curTool.x/2.0),
                                              currentLayerNum);

                      graphic->addArc(xOrder*factor, (yOrder*factor+curTool.y/2.0-curTool.x/2.0),
                                             curTool.x/2.0,
                                             180.0, 0.0,
                                             true,
                                             currentLayerNum);

                      graphic->addLine((xOrder*factor+curTool.x/2.0),
                                              (yOrder*factor+curTool.y/2.0-curTool.x/2.0),
                                              (xOrder*factor+curTool.x/2.0),
                                              (yOrder*factor-curTool.y/2.0+curTool.x/2.0),
                                              currentLayerNum);

                      graphic->addArc(xOrder*factor, (yOrder*factor-curTool.y/2.0+curTool.x/2.0),
                                             curTool.x/2.0,
                                             0.0, 180.0,
                                             true,
                                             currentLayerNum);
                    }
                    else {
                      graphic->addLine((xOrder*factor-curTool.x/2.0+curTool.y/2.0),
                                              (yOrder*factor-curTool.y/2.0),
                                              (xOrder*factor+curTool.x/2.0-curTool.y/2.0),
                                              (yOrder*factor-curTool.y/2.0),
                                              currentLayerNum);

                      graphic->addArc((xOrder*factor+curTool.x/2.0-curTool.y/2.0), yOrder*factor,
                                             curTool.y/2.0,
                                             270.0, 90.0,
                                             false,
                                             currentLayerNum);

                      graphic->addLine((xOrder*factor+curTool.x/2.0-curTool.y/2.0),
                                              (yOrder*factor+curTool.y/2.0),
                                              (xOrder*factor-curTool.x/2.0+curTool.y/2.0),
                                              (yOrder*factor+curTool.y/2.0),
                                              currentLayerNum);

                      graphic->addArc((xOrder*factor-curTool.x/2.0+curTool.y/2.0), yOrder*factor,
                                             curTool.y/2.0,
                                             90.0, 270.0,
                                             false,
                                             currentLayerNum);
                    }

                    break;

                  default:
                    break;
                }


                toolIsDown=false;   // Light off after flash
                currentX=xOrder;
                currentY=yOrder;
              }


              if(toolIsDown) {

                switch(gOrder) {

                  case 1:
                    // -----
                    // Line:
                    // -----
                    graphic->addLine(currentX*factor,
                                            currentY*factor,
                                            xOrder*factor,
                                            yOrder*factor,
                                            currentLayerNum);
                    currentX=xOrder;
                    currentY=yOrder;
                    break;

                  case 2:
                  case 3:
                    // ----
                    // Arc:
                    // ----
                    if(iChange || jChange) {
                      vcx=currentX+iOrder;
                      vcy=currentY+jOrder;
                      vcr=mtGetDistance(vcx, vcy, currentX, currentY);
                    }

                    if(!mtCompFloat(0.0, vcr)) {

                      va1=mtGetAngle(vcx, vcy, currentX, currentY);
                      va2=mtGetAngle(vcx, vcy, xOrder, yOrder);

                      // Circle:
                      //
                      if(mtCompFloat(va1, va2)) {
                        graphic->addCircle(vcx*factor,
                                                  vcy*factor,
                                                  vcr*factor,
                                                  0.0, 360.0,
                                                  false, currentLayerNum);
                      }
                      else {

                        // Arc:
                        //
                        if(gOrder==2 || gOrder==12) {
                          graphic->addArc(vcx*factor,
                                                 vcy*factor,
                                                 vcr*factor,
                                                 va1, va2,
                                                 true, currentLayerNum);
                        }
                        else {
                          graphic->addArc(vcx*factor,
                                                 vcy*factor,
                                                 vcr*factor,
                                                 va1, va2,
                                                 false, currentLayerNum);
                        }
                      }
                    }

                    currentX=xOrder;
                    currentY=yOrder;
                    break;

                  default:
                    break;
                }
              }

              /*if(++updProgress==1000) {
                np->GetStateWin()->UpdateProgressBar((int)(pcFact*vc)+25);
                updProgress=0;
              }*/
            }
          }
        }
      }
    }while(gerLine && !prgEnd);

    // Set the new number of elements in the graphic (1st free el):
    //
    //nGr->SetVNum(vc);

    /*
    NIni::GetNIni()->LogMessage("I read...");
    NIni::GetNIni()->LogMessage((int)vc);
    NIni::GetNIni()->LogMessage("...Elements");
    NIni::GetNIni()->LogMessage("");
    */

    // Update Layers:
    //
    //if(np->GetLayerWin()) np->GetLayerWin()->UpdateLayers();

    //np->GetCadWin()->SetCursor(0, IDC_ARROW);
  }
  else {
    //NIni::GetNIni()->LogMessage("FileBuffer is empty - Can't read NC");
  }

  //np->GetStateWin()->DelProgressBar();

  return true;
}



// save a cxf file:
//
bool
RFileGbx::save()
{
  return false;
}


















