/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999 Ondrejicka Stefan			   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk_imlib.h>
#include <gdk/gdkx.h>

#include "chbg_logo.xpm"
#include "stock_open.xpm"
#include "stock_save_as.xpm"
#include "stock_exit.xpm"
#include "stock_exec.xpm"
#include "stock_exec_term.xpm"
#include "stock_apply.xpm"
#include "stock_stop.xpm"

static GtkWidget *toplevel_window;
static GtkWidget *interval;
static GtkWidget *max_grow;
static GtkWidget *max_size;
static GtkWidget *background;
static GtkWidget *background2;
static GtkWidget *background_en;
static GtkWidget *background2_en;
static GtkWidget *rand_colors;
static GtkWidget *efect;
static GtkWidget *shader;
static GtkWidget *type[5];
static GtkWidget *speed;
static GtkWidget *recurse;
static GtkWidget *prop_interval;
static GtkWidget *prop_max_grow;
static GtkWidget *prop_max_size;
static GtkWidget *prop_type[5];
static GtkWidget *prop_pname;
static GtkWidget *prop_have;
static GtkWidget *prop_background;
static GtkWidget *prop_background2;
static GtkWidget *prop_background_en;
static GtkWidget *prop_background2_en;
static GtkWidget *prop_rand_colors;
static GdkColor  prop_bgc;
static GdkColor  prop_bg2c;
static GtkWidget *prop_efect;
static GtkWidget *prop_shader;
static GtkWidget *randomized;
static GtkWidget *blank;
static GtkWidget *picture_list;
static GtkWidget *list_menu;
static GtkWidget *screensaver;
static GtkWidget *preview;
static GtkWidget *preview_info;
static GtkAccelGroup *menu_accel_group;
static GtkWidget *inwindow;
static GtkWidget *patternw;
static GtkWidget *cycle_blank;

guint run = FALSE;
guint changed_list = FALSE;
guint restart_loop = FALSE;

static void set_color_preview();
static void build_propt();
extern char *cfg_get_color_str();
extern void run_changing_process();
extern void recurse_dir();

extern gboolean stop_changing;
extern gboolean have_setup;

static GtkTargetEntry dragtypes[] = {
	{"STRING",		0,	0},
	{"text/plain",		0,	0}
};

#ifndef MIN
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#endif

static void get_cfg()
{
	char *p;
	int l;
	guint row;
	picentry *pe;
	propt *pprop;

	cfg.properties.interval = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(interval));
	cfg.properties.max_size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(max_size));
	cfg.properties.max_grow = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(max_grow));
	cfg.properties.efect = GTK_OPTION_MENU(efect)->menu_item ? (guint) gtk_object_get_user_data(GTK_OBJECT(GTK_OPTION_MENU(efect)->menu_item)) : 0;
	cfg.properties.shade = GTK_OPTION_MENU(shader)->menu_item ? (guint) gtk_object_get_user_data(GTK_OBJECT(GTK_OPTION_MENU(shader)->menu_item)) : 0;
	cfg.properties.rand_colors = GTK_TOGGLE_BUTTON(rand_colors)->active;

	cfg.speed =  gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(speed));

	cfg.randomize = GTK_TOGGLE_BUTTON(randomized)->active;
	cfg.blank = GTK_TOGGLE_BUTTON(blank)->active;
	cfg.screensaver = GTK_TOGGLE_BUTTON(screensaver)->active;
	cfg.recurse = GTK_TOGGLE_BUTTON(recurse)->active;
	cfg.inwindow = GTK_TOGGLE_BUTTON(inwindow)->active;
	cfg.cycle_blank = GTK_TOGGLE_BUTTON(cycle_blank)->active;


	while(cfg.pattern)
	{
		g_free(cfg.pattern->data);
		cfg.pattern = g_slist_remove_link(cfg.pattern, cfg.pattern);
	}
	p = gtk_entry_get_text(GTK_ENTRY(patternw));

	while(*p)
	{
		p += strspn(p , " ");
		l = strcspn(p , " ");
		if (l)
			cfg.pattern = g_slist_append(cfg.pattern, g_strndup(p , l));
		p += l;
	}
	
	if (changed_list)
	{
		changed_list = FALSE;
		while(cfg.pics)
		{
			pe = (picentry *) cfg.pics->data;

			if (pe->prop) g_free(pe->prop);
			g_free(pe->name);
			g_free(pe);
			cfg.pics = g_slist_remove_link(cfg.pics , cfg.pics);
		}
		cfg.num_pics = 0;

		for (row = 0 ; row < GTK_CLIST(picture_list)->rows ; row++)
		{
			pe = g_malloc(sizeof(picentry));

			gtk_clist_get_text(GTK_CLIST(picture_list) , row , 0 , &p);
			pe->name = g_strdup(p);
			pe->prop = NULL;

			pprop = gtk_clist_get_row_data(GTK_CLIST(picture_list) , row);
			if (pprop) pe->prop = g_memdup(pprop , sizeof(propt));

			cfg.pics = g_slist_append(cfg.pics , (gpointer)pe);
			cfg.num_pics ++;
		}
	}
}

static void set_cfg()
{
	GSList *ptr;
	picentry *pe;
	gint row;

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(interval) , (gfloat)cfg.properties.interval);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(interval))) , "value_changed");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(max_grow) , (gfloat)cfg.properties.max_grow);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(max_grow))) , "value_changed");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(max_size) , (gfloat)cfg.properties.max_size);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(max_size))) , "value_changed");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(speed) , (gfloat)cfg.speed);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(speed))) , "value_changed");	
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(randomized) , cfg.randomize);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(blank) , cfg.blank);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(screensaver) , cfg.screensaver);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(recurse) , cfg.recurse);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(inwindow) , cfg.inwindow);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cycle_blank) , cfg.cycle_blank);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(type[cfg.properties.type]) , TRUE);
	gtk_option_menu_set_history(GTK_OPTION_MENU(efect) , cfg.properties.efect);
	gtk_option_menu_set_history(GTK_OPTION_MENU(shader) , cfg.properties.shade);

	set_color_preview(background , background_en , &cfg.properties.background);
	set_color_preview(background2 , background2_en , &cfg.properties.background2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rand_colors) , cfg.properties.rand_colors);

	ptr = cfg.pattern;
	gtk_entry_set_text(GTK_ENTRY(patternw) , "");
	while(ptr)
	{
		gtk_entry_append_text(GTK_ENTRY(patternw) , (char *)ptr->data);
		ptr = ptr->next;
		if (ptr)
			gtk_entry_append_text(GTK_ENTRY(patternw) , " ");
	}

	gtk_clist_freeze(GTK_CLIST(picture_list));
	gtk_clist_clear(GTK_CLIST(picture_list));
	ptr = cfg.pics;
	while(ptr)
	{
		pe = (picentry *)ptr->data;

		row = gtk_clist_append(GTK_CLIST(picture_list) , (gchar **)&pe->name);
		if (pe->prop)
			gtk_clist_set_row_data_full(GTK_CLIST(picture_list) , row ,
				g_memdup(pe->prop , sizeof(propt)) , g_free);
		ptr = ptr->next;
	}
	gtk_clist_thaw(GTK_CLIST(picture_list));
	changed_list = TRUE;
}

GtkWidget *menubar_item(field)
gchar *field;
{
	GtkWidget *item,*label;
	guint accelerator_key;
 
	item = gtk_menu_item_new();

	label = gtk_accel_label_new(field);
	gtk_widget_show(label);
	gtk_container_add(GTK_CONTAINER(item) , label);

	accelerator_key = 
		gtk_label_parse_uline (GTK_LABEL (label), field);

	if (accelerator_key != GDK_VoidSymbol)
	{
		if (!menu_accel_group)
			menu_accel_group = gtk_accel_group_new ();

		gtk_widget_add_accelerator (item,
			"activate_item",
			menu_accel_group,
			accelerator_key,
			GDK_MOD1_MASK,
			GTK_ACCEL_LOCKED);
	}

	return item;
}

static void set_dir(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gchar **p = (gchar **) func_data;

	if (*p) g_free(*p);

	*p = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(object)));
}

static void SelectAll(object , func_data)
GtkObject *object;
gpointer func_data;
{
	if (GTK_CLIST(func_data)->rows > 0)
		gtk_clist_select_all(GTK_CLIST(func_data));
}

static void Quit(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_widget_destroy(toplevel_window);

	if (!run)  gtk_exit(0);
}

static void QuitReal(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_exit(0);
}

static void KillWin(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_widget_destroy(GTK_WIDGET(func_data));
}


static void KillAll(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget **w = (GtkWidget **)func_data;

	if (*w)
		gtk_widget_destroy(*w);
}

static void SwitchMode(object , func_data)
GtkObject *object;
gpointer func_data;
{
	shtype *type = (shtype *)func_data;
	
	if (GTK_TOGGLE_BUTTON(object)->active)
		*type = (shtype) gtk_object_get_user_data(object);
}

static void LoadIt(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char *fn = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));

	if (fn && *fn)
	{
		cfg_scenario(fn);
		set_cfg();
		gtk_widget_destroy(GTK_WIDGET(func_data));
	}
	else gdk_beep();
}

static void LoadScn(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_file_selection_new(gettext("ChBg: Load scenario"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(w) , dir);

	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(w));

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(LoadIt), w);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}

static void SaveIt(object , func_data)
GtkObject *object;
gpointer func_data;
{
	char *fn = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));

	if (fn && *fn)
	{
		get_cfg();
		cfg_save_scenario(fn);
		if (run)
			recurse_dir();
		gtk_widget_destroy(GTK_WIDGET(func_data));
	}
	else gdk_beep();
}

static void SaveScn(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_file_selection_new(gettext("ChBg: Save scenario"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(w) , dir);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(SaveIt), w);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}

static void Run(object , func_data)
GtkObject *object;
gpointer func_data;
{
	stop_changing = FALSE;
	if (run)
	{
		gdk_beep();
		return;
	}

	get_cfg();
	run = TRUE;
	run_changing_process();
	gdk_event_handler_set ((GdkEventFunc)gtk_main_do_event, NULL, NULL);
	run = FALSE;
}

static void RunTerm(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gboolean is_run = run;

	stop_changing = FALSE;
	run = TRUE;
	get_cfg();
	gtk_widget_destroy(toplevel_window);
	while (gtk_events_pending()) gtk_main_iteration();
	have_setup = FALSE;
	if (!is_run)
	{
		run = TRUE;
		run_changing_process();
		gtk_main_quit();
	}
	toplevel_window = NULL;
}

static void ApplyChanges(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (run && changed_list)
	{
		get_cfg();
		recurse_dir();
		restart_loop = TRUE;
	}
	else
		get_cfg();
}

static void Stop(object, func_data)
GtkObject *object;
gpointer func_data;
{
	if (run)
	{
		stop_changing = TRUE;
		if (gtk_main_level() > 1)
			gtk_main_quit();
	}
}

static void About(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	GtkWidget *button , *col , *label , *box , *pixmap , *frame;
	gchar pom[PATH_MAX];
	GdkPixmap *pmap;
	GdkBitmap *mask;
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(w) , gettext("ChBg: About"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	col = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(w) , col);
	gtk_widget_show(col);

	frame = gtk_frame_new(NULL);
	gtk_container_add(GTK_CONTAINER(col) , frame);
	gtk_widget_show(frame);

	box = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(frame) , box);
	gtk_widget_show(box);

	pmap = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(toplevel_window)->window , 
			&mask , NULL , chbg_logo_xpm);

	pixmap = gtk_pixmap_new(pmap , mask);
	gtk_container_add(GTK_CONTAINER(box) , pixmap);
	gtk_widget_show(pixmap);

	sprintf(pom , gettext("ChBg %s\n\nManager & changer of background pictures\n\n"
			      "By Ondrejicka Stefan\n\n(ondrej@idata.sk)\n\nURL : http://www.idata.sk/~ondrej/chbg/\n") , VERSION);

	label = gtk_label_new(pom);
	gtk_container_add(GTK_CONTAINER(box) , label);
	gtk_widget_show(label);

	button = gtk_button_new_with_label(gettext("Cancel"));
	gtk_box_pack_start(GTK_BOX(col) , button , FALSE , TRUE , 1);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(KillWin) , (gpointer)w);

	gtk_widget_show(w);

	frst = FALSE;
}

guint listed(str)
gchar *str;
{
	int i;
	gchar *p;

	for (i = 0 ; i < GTK_CLIST(picture_list)->rows ; i++)
	{
		gtk_clist_get_text(GTK_CLIST(picture_list) ,
			i , 0 , &p);

		if (!strcmp(str , p))
			return TRUE;
	}

	return FALSE;
}

static void AppendIt(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GList *ptr = GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list)->selection;
	gchar *p;
	gchar pom[PATH_MAX];
	gchar dir[PATH_MAX];

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(func_data));
	strcpy(dir , p);
	p = strrchr(dir , '/');
	if (p) *p = '\0';

	gtk_clist_freeze(GTK_CLIST(picture_list));

	if (!ptr && dir)
	{
		if (!listed(dir))
		{
			p = dir;
			gtk_clist_append(GTK_CLIST(picture_list) , (gchar **)&p);
			changed_list = TRUE;
		}
	}

	while(ptr)
	{
		gtk_clist_get_text(GTK_CLIST(GTK_FILE_SELECTION(func_data)->file_list) ,
			GPOINTER_TO_INT(ptr->data) , 0 , &p);
		sprintf(pom , "%s/%s" , dir , p);
		p = pom;
		if (!listed(p))
		{
			gtk_clist_append(GTK_CLIST(picture_list) , (gchar **)&p);
			changed_list = TRUE;
		}
		ptr = ptr->next;
	}
	gtk_clist_thaw(GTK_CLIST(picture_list));
}

static void Preview(object , func_data)
GtkObject *object;
gpointer func_data;
{
	GtkWidget *fs = (GtkWidget *) func_data;
	GtkWidget *pmap;
	GdkImlibImage *img;
	GdkPixmap *pixmap;
	char *p;
	guint w,h;
	gfloat scale;
	gchar pom[50];

	if (GTK_BIN(preview)->child) gtk_widget_destroy(GTK_BIN(preview)->child);
	gtk_label_set(GTK_LABEL(preview_info) , "");

	p = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
	
	if (!p)
	{
		gdk_beep();
		return;
	}


	img = gdk_imlib_load_image(p);

	if (!img)
	{
		gdk_beep();
		return;
	}

	w = MIN(preview->allocation.width - 2 * (GTK_CONTAINER(preview)->border_width +
		GTK_WIDGET (preview)->style->klass->xthickness) , img->rgb_width);
	h = MIN(preview->allocation.height - 2 * (GTK_CONTAINER(preview)->border_width +
		GTK_WIDGET (preview)->style->klass->ythickness) -
		GTK_FRAME(preview)->label_height , img->rgb_height);

	scale = 1.0;
	
	if (img->rgb_width > w) scale = (gfloat)w / (gfloat)img->rgb_width;
	if (img->rgb_height > h) scale = MIN((gfloat)h / (gfloat)img->rgb_height , scale);

	w = (guint)(scale * img->rgb_width);
	h = (guint)(scale * img->rgb_height);
	
	gdk_imlib_render(img , w , h);
	pixmap = gdk_imlib_move_image(img);

	pmap = gtk_pixmap_new(pixmap , NULL);
	gtk_container_add(GTK_CONTAINER(preview) , pmap);
	gtk_widget_show(pmap);

	sprintf(pom , gettext("Size :  %d x %d  ") , img->rgb_width , img->rgb_height);
	gtk_label_set(GTK_LABEL(preview_info) , pom);

	gdk_imlib_free_pixmap(pixmap);
	gdk_imlib_kill_image(img);

}

static void AppendDlg(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	GtkWidget *button;
	static gchar* dir = NULL;
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_file_selection_new(gettext("ChBg: Get pictures"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(set_dir), &dir);

	if (dir)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(w) , dir);

	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(w));

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(AppendIt), w);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_clist_set_selection_mode(GTK_CLIST(GTK_FILE_SELECTION (w)->file_list) ,
		GTK_SELECTION_MULTIPLE);

	preview = gtk_frame_new(gettext("preview"));
	gtk_widget_set_usize(preview , 180 , -1);
	gtk_container_set_border_width (GTK_CONTAINER (preview), 5);
	gtk_box_pack_end(GTK_BOX(GTK_FILE_SELECTION (w)->file_list->parent->parent) , preview ,
				TRUE , TRUE , 0);
	gtk_widget_show(preview);


	preview_info = gtk_label_new ("");
	gtk_misc_set_alignment (GTK_MISC(preview_info) , 1.0 , 0.5);
	gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION (w)->selection_text->parent), 
			preview_info, FALSE, FALSE, 0);
	gtk_box_reorder_child(GTK_BOX(GTK_FILE_SELECTION (w)->selection_text->parent) ,
			preview_info , 0);
	gtk_widget_show (preview_info);

	button = gtk_button_new_with_label(gettext("Select All"));
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(w)->ok_button->parent) , button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(SelectAll) , 
			(gpointer)(GTK_FILE_SELECTION (w)->file_list));


	button = gtk_button_new_with_label(gettext("Append"));
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(w)->ok_button->parent) , button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(AppendIt) , 
			(gpointer)w);

	button = gtk_button_new_with_label(gettext("Preview"));
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(w)->ok_button->parent) , button);
	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	gtk_widget_show(button);

	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(Preview) , 
			(gpointer)w);


	gtk_widget_show(w);

	frst = FALSE;
}

static void PreviewDlg(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	static GtkWidget *pmap,*col;
	GtkWidget *button;
	GdkImlibImage *img = NULL;
	GdkPixmap *pixmap;
	gchar *p = NULL;
	static gboolean frst = TRUE;

	if (GTK_CLIST(picture_list)->focus_row >= 0)
		gtk_clist_get_text(GTK_CLIST(picture_list) , 
			GTK_CLIST(picture_list)->focus_row , 0 , &p);

	if (p)
		img = gdk_imlib_load_image(p);

	if (!img)
	{
		gdk_beep();
		return;
	}

	if (w)
	{
		gdk_window_raise(w->window);
		gtk_widget_destroy(pmap);
	}
	else
	{
		w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(w) , gettext("ChBg: Preview"));
		gtk_window_set_policy(GTK_WINDOW(w) , FALSE , FALSE , TRUE);
		gtk_signal_connect (GTK_OBJECT (w), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);

		if (frst)
			gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
				GTK_SIGNAL_FUNC(KillAll), &w);


		col = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(w) , col);
		gtk_widget_show(col);

		button = gtk_button_new_with_label(gettext("Close"));
		gtk_box_pack_end(GTK_BOX(col) , button , FALSE , TRUE , 2);
		GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
		gtk_widget_show(button);
		gtk_signal_connect (GTK_OBJECT(button),
			"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	}

	gdk_imlib_render(img , img->rgb_width , img->rgb_height);
	pixmap = gdk_imlib_move_image(img);

	pmap = gtk_pixmap_new(pixmap , NULL);
	gtk_box_pack_start(GTK_BOX(col) , pmap , FALSE , TRUE , 2);
	gtk_widget_show(pmap);

	gdk_imlib_free_pixmap(pixmap);
	gdk_imlib_kill_image(img);

	gtk_widget_show(w);

	frst = FALSE;
}

#define RED	0
#define GREEN	1
#define BLUE	2
#define OPACITY	3

static void set_color_preview(w , iw , color)
GtkWidget *w;
GtkWidget *iw;
GdkColor *color;
{
	gint width, height, x, y ,n;
	guchar *sample;
	guchar c[3];

	c[RED] = (guchar) (color->red / 256);
	c[GREEN] = (guchar) (color->green / 256);
	c[BLUE] = (guchar) (color->blue / 256);

	width = w->allocation.width;
	height = w->allocation.height;

	sample = g_new(guchar, 3 * width);

	for (x = 0 ; x < width ; x++)
		for (n = 0; n < 3; n++)
			sample[3*x + n] = c[n];

	for (y = 0 ; y < height ; y++)
	{
		gtk_preview_draw_row (GTK_PREVIEW (w), sample, 0, y, width);
	}

	g_free(sample);
	gtk_widget_queue_draw (w);

	gtk_label_set_text(GTK_LABEL(iw) , cfg_get_color_str(color));
}

static void ColorIt(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gdouble color[4];

	gtk_color_selection_get_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (func_data)->colorsel) , color);

	cfg.properties.background.red = color[RED] * 65535;
	cfg.properties.background.green = color[GREEN] * 65535;
	cfg.properties.background.blue = color[BLUE] * 65535;

	set_color_preview(background , background_en , &cfg.properties.background);

	gtk_widget_destroy(GTK_WIDGET(func_data));
}

static void ColorIt2(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gdouble color[4];

	gtk_color_selection_get_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (func_data)->colorsel) , color);

	cfg.properties.background2.red = color[RED] * 65535;
	cfg.properties.background2.green = color[GREEN] * 65535;
	cfg.properties.background2.blue = color[BLUE] * 65535;

	set_color_preview(background2 , background2_en , &cfg.properties.background2);

	gtk_widget_destroy(GTK_WIDGET(func_data));
}


static void ColorPropIt(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gdouble color[4];

	gtk_color_selection_get_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (func_data)->colorsel) , color);

	prop_bgc.red = color[RED] * 65535;
	prop_bgc.green = color[GREEN] * 65535;
	prop_bgc.blue = color[BLUE] * 65535;

	set_color_preview(prop_background , prop_background_en , &prop_bgc);

	gtk_widget_destroy(GTK_WIDGET(func_data));
}

static void ColorPropIt2(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gdouble color[4];

	gtk_color_selection_get_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (func_data)->colorsel) , color);

	prop_bg2c.red = color[RED] * 65535;
	prop_bg2c.green = color[GREEN] * 65535;
	prop_bg2c.blue = color[BLUE] * 65535;

	set_color_preview(prop_background2 , prop_background2_en , &prop_bg2c);

	gtk_widget_destroy(GTK_WIDGET(func_data));
}

static void ColorDlg(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	gdouble color[4];
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_color_selection_dialog_new(gettext("ChBg: Get background color"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	color[RED] = ((gdouble)cfg.properties.background.red) / 65535.0;
	color[GREEN] = ((gdouble)cfg.properties.background.green) / 65535.0;
	color[BLUE] = ((gdouble)cfg.properties.background.blue) / 65535.0;
	color[OPACITY] = 1.0;

	gtk_color_selection_set_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , color);
	gtk_color_selection_set_opacity(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , FALSE);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(ColorIt), w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}

static void ColorDlg2(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	gdouble color[4];
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_color_selection_dialog_new(gettext("ChBg: Get background color 2"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	color[RED] = ((gdouble)cfg.properties.background2.red) / 65535.0;
	color[GREEN] = ((gdouble)cfg.properties.background2.green) / 65535.0;
	color[BLUE] = ((gdouble)cfg.properties.background2.blue) / 65535.0;
	color[OPACITY] = 1.0;

	gtk_color_selection_set_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , color);
	gtk_color_selection_set_opacity(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , FALSE);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(ColorIt2), w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}


static void ColorPropDlg(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	gdouble color[4];
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_color_selection_dialog_new(gettext("ChBg: Get Properties: background color"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	color[RED] = ((gdouble)prop_bgc.red) / 65535.0;
	color[GREEN] = ((gdouble)prop_bgc.green) / 65535.0;
	color[BLUE] = ((gdouble)prop_bgc.blue) / 65535.0;
	color[OPACITY] = 1.0;

	gtk_color_selection_set_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , color);
	gtk_color_selection_set_opacity(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , FALSE);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(ColorPropIt), w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}

static void ColorPropDlg2(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	gdouble color[4];
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}

	w = gtk_color_selection_dialog_new(gettext("ChBg: Get Properties: background color 2"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	color[RED] = ((gdouble)prop_bg2c.red) / 65535.0;
	color[GREEN] = ((gdouble)prop_bg2c.green) / 65535.0;
	color[BLUE] = ((gdouble)prop_bg2c.blue) / 65535.0;
	color[OPACITY] = 1.0;

	gtk_color_selection_set_color(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , color);
	gtk_color_selection_set_opacity(GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG (w)->colorsel) , FALSE);

	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(ColorPropIt2), w);

	gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (w)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(KillWin), w);

	gtk_widget_show(w);

	frst = FALSE;
}

static void SelCh(object , func_data)
GtkObject *object;
gpointer func_data;
{
	propt *p = NULL;
	gchar *t = gettext("(none)");

	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		gtk_clist_get_text(GTK_CLIST(picture_list) , 
			GTK_CLIST(picture_list)->focus_row , 0 , &t);

		p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,
			GTK_CLIST(picture_list)->focus_row);
	}
	if (p)
	{
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(prop_interval) , (gfloat)p->interval);
		gtk_signal_emit_by_name(GTK_OBJECT(
			gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(prop_interval))) , "value_changed");
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(prop_max_grow) , (gfloat)p->max_grow);
		gtk_signal_emit_by_name(GTK_OBJECT(
			gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(prop_max_grow))) , "value_changed");
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(prop_max_size) , (gfloat)p->max_size);
		gtk_signal_emit_by_name(GTK_OBJECT(
			gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(prop_max_size))) , "value_changed");

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_type[p->type]) , TRUE);


		set_color_preview(prop_background , prop_background_en , &p->background);
		set_color_preview(prop_background2 , prop_background2_en , &p->background2);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rand_colors) , p->rand_colors);

		gtk_option_menu_set_history(GTK_OPTION_MENU(prop_efect) , p->efect);
		gtk_option_menu_set_history(GTK_OPTION_MENU(prop_shader) , p->shade);

	}

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have) , p != NULL);
	gtk_label_set_text(GTK_LABEL(prop_pname) , t);
}

static void KillProp(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_signal_disconnect_by_func(GTK_OBJECT(picture_list) , GTK_SIGNAL_FUNC(SelCh) , NULL);
}


static void ClearProp(object , func_data)
GtkObject *object;
gpointer func_data;
{
	propt *p = NULL;

	changed_list = TRUE;

	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,
			GTK_CLIST(picture_list)->focus_row);

		if (p)
		{
			gtk_clist_set_row_data(GTK_CLIST(picture_list) , 
				GTK_CLIST(picture_list)->focus_row , NULL);
			g_free(p);
		}
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have) , FALSE);
	}
	else gdk_beep();
}

static void ResetProp(object , func_data)
GtkObject *object;
gpointer func_data;
{
	changed_list = TRUE;

	gtk_spin_button_set_value(GTK_SPIN_BUTTON(prop_interval) , (gfloat)cfg.properties.interval);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(prop_interval))) , "value_changed");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(prop_max_grow) , (gfloat)cfg.properties.max_grow);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(prop_max_grow))) , "value_changed");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(prop_max_size) , (gfloat)cfg.properties.max_size);
	gtk_signal_emit_by_name(GTK_OBJECT(
		gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(prop_max_size))) , "value_changed");

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_type[cfg.properties.type]) , TRUE);

	memcpy((void *)&prop_bgc, (void *)&cfg.properties.background, sizeof(GdkColor));
	set_color_preview(prop_background , prop_background_en , &prop_bgc);

	memcpy((void *)&prop_bg2c, (void *)&cfg.properties.background2, sizeof(GdkColor));
	set_color_preview(prop_background2 , prop_background2_en , &prop_bg2c);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_rand_colors) , cfg.properties.rand_colors);

	gtk_option_menu_set_history(GTK_OPTION_MENU(prop_efect) , cfg.properties.efect);
	gtk_option_menu_set_history(GTK_OPTION_MENU(prop_shader) , cfg.properties.shade);

}

static void ApplyProp(object , func_data)
GtkObject *object;
gpointer func_data;
{
	propt *p;
	gint have_prop = TRUE;

	changed_list = TRUE;

	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,
			GTK_CLIST(picture_list)->focus_row);
		if (!p)
		{
			have_prop = FALSE;
			p = g_malloc(sizeof(propt));
		}

		p->interval = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(prop_interval));
		p->max_size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(prop_max_size));
		p->max_grow = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(prop_max_grow));
		p->type = ((propt *)func_data)->type;

		memcpy((void *)&p->background, (void *)&prop_bgc, sizeof(GdkColor));
		memcpy((void *)&p->background2, (void *)&prop_bg2c, sizeof(GdkColor));
		p->efect = GTK_OPTION_MENU(prop_efect)->menu_item ? (guint)gtk_object_get_user_data(GTK_OBJECT(GTK_OPTION_MENU(prop_efect)->menu_item)) : 0;
		p->shade = GTK_OPTION_MENU(prop_shader)->menu_item ? (guint)gtk_object_get_user_data(GTK_OBJECT(GTK_OPTION_MENU(prop_shader)->menu_item)) : 0;
		p->rand_colors = GTK_TOGGLE_BUTTON(prop_rand_colors)->active;

		if (!have_prop)
			gtk_clist_set_row_data_full(GTK_CLIST(picture_list) ,
				GTK_CLIST(picture_list)->focus_row , p , g_free);

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have) , TRUE);
	}
	else
		gdk_beep();
}

static void PropDlg(object , func_data)
GtkObject *object;
gpointer func_data;
{
	static GtkWidget *w;
	static propt pprop;
	propt *p = NULL;
	GtkWidget *box , *hbox , *button , *f;
	gchar *t = gettext("(none)");
	static gboolean frst = TRUE;

	if (w)
	{
		gdk_window_raise(w->window);
		return;
	}
	w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(w) , gettext("ChBg: Picture properties"));
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(KillProp), &w);
	gtk_signal_connect (GTK_OBJECT (w), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &w);
	if (frst)
		gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
			GTK_SIGNAL_FUNC(KillAll), &w);

	pprop.interval = cfg.properties.interval;
	pprop.type = cfg.properties.type;
	pprop.max_grow = cfg.properties.max_grow;
	pprop.max_size = cfg.properties.max_size;
	pprop.efect = cfg.properties.efect;
	pprop.shade = cfg.properties.shade;

	memcpy((void *)&pprop.background, (void *)&cfg.properties.background , sizeof(GdkColor));
	memcpy((void *)&pprop.background2, (void *)&cfg.properties.background2 , sizeof(GdkColor));
	pprop.rand_colors = cfg.properties.rand_colors;

	if (GTK_CLIST(picture_list)->focus_row >= 0)
	{
		gtk_clist_get_text(GTK_CLIST(picture_list) , 
			GTK_CLIST(picture_list)->focus_row , 0 , &t);

		if ((p = gtk_clist_get_row_data(GTK_CLIST(picture_list) ,
			GTK_CLIST(picture_list)->focus_row)))
		{
			pprop.interval = p->interval;
			pprop.type = p->type;
			pprop.max_grow = p->max_grow;
			pprop.max_size = p->max_size;
			pprop.efect = p->efect;
			pprop.shade = p->shade;
			memcpy((void *)&pprop.background, (void *)&p->background , sizeof(GdkColor));
			memcpy((void *)&pprop.background2, (void *)&p->background2 , sizeof(GdkColor));
			pprop.rand_colors = p->rand_colors;
		}
	}

	box = gtk_vbox_new(FALSE , 1);
	gtk_container_add(GTK_CONTAINER(w) , box);
	gtk_widget_show(box);

	f = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(box) , f , FALSE , TRUE , 3);
	gtk_widget_show(f);

	prop_pname = gtk_label_new(t);
	gtk_container_add(GTK_CONTAINER(f) , prop_pname);
	gtk_widget_show(prop_pname);

	prop_have = gtk_check_button_new_with_label(gettext("Own properties"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prop_have) , p != NULL);
	gtk_widget_set_sensitive(prop_have , FALSE);
	gtk_box_pack_start(GTK_BOX(box) , prop_have , FALSE , TRUE , 0);
	gtk_widget_show(prop_have);

	build_propt(box , &pprop , &prop_interval , &prop_max_grow , &prop_max_size , &prop_type , &prop_background , &prop_background_en , ColorPropDlg , &prop_background2 , &prop_background2_en , ColorPropDlg2 , &prop_efect , &prop_shader, &prop_rand_colors);

	hbox = gtk_hbutton_box_new();
	gtk_box_pack_end(GTK_BOX(box) , hbox , FALSE , TRUE , 0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label(gettext("Close"));
	gtk_box_pack_end(GTK_BOX(hbox) , button , FALSE , TRUE , 0);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(KillWin), w);

	button = gtk_button_new_with_label(gettext("Apply"));
	gtk_box_pack_start(GTK_BOX(hbox) , button , FALSE , TRUE , 0);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ApplyProp) , &pprop);

	button = gtk_button_new_with_label(gettext("Clear"));
	gtk_box_pack_start(GTK_BOX(hbox) , button , FALSE , TRUE , 0);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ClearProp) , NULL);

	button = gtk_button_new_with_label(gettext("Reset"));
	gtk_box_pack_start(GTK_BOX(hbox) , button , FALSE , TRUE , 0);
	gtk_widget_show(button);
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(ResetProp) , NULL);

	gtk_signal_connect(GTK_OBJECT(picture_list) , "select_row" ,
		GTK_SIGNAL_FUNC(SelCh) , NULL);
	gtk_signal_connect(GTK_OBJECT(picture_list) , "unselect_row" ,
		GTK_SIGNAL_FUNC(SelCh) , NULL);
	gtk_signal_connect(GTK_OBJECT(picture_list) , "scroll_vertical" ,
		GTK_SIGNAL_FUNC(SelCh) , NULL);

	gtk_widget_show(w);

	set_color_preview(prop_background , prop_background_en , &pprop.background);

	set_color_preview(prop_background2 , prop_background2_en , &pprop.background2);

	frst = FALSE;
}

static void build_menu(parent)
GtkWidget *parent;
{
	GtkWidget *mbar,*menu,*mbb,*mi;

	menu_accel_group = NULL;

        mbar = gtk_menu_bar_new();
        gtk_widget_show (mbar);

	gtk_box_pack_start(GTK_BOX(parent) , mbar , FALSE , TRUE , 1);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

	mi = gtk_menu_item_new_with_label(gettext("Open Scenario ..."));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(LoadScn) , (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Save Scenario ..."));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(SaveScn) , (gpointer)NULL);

	mi = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	mi = gtk_menu_item_new_with_label(gettext("Quit"));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(QuitReal) , (gpointer)NULL);

	mbb = menubar_item(gettext("_File"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);
	
	mi = gtk_menu_item_new_with_label(gettext("Run"));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(Run) , (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Hide window & run"));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(RunTerm) , (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Stop"));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(Stop) , (gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Apply changes"));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
		GTK_SIGNAL_FUNC(ApplyChanges) , (gpointer)NULL);

	mbb = menubar_item(gettext("_Action"));
	gtk_widget_show (mbb);
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

	menu = gtk_menu_new();
	gtk_widget_realize (menu);

	mi = gtk_menu_item_new_with_label(gettext("About ..."));
	gtk_menu_append(GTK_MENU(menu) , mi);
	gtk_widget_show (mi);

	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(About) , 
			(gpointer)NULL);

	mbb = menubar_item(gettext("_Help"));
	gtk_widget_show (mbb);
	gtk_menu_item_right_justify(GTK_MENU_ITEM(mbb));
	gtk_menu_bar_append(GTK_MENU_BAR(mbar) , mbb);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mbb) , menu);

	gtk_accel_group_attach (menu_accel_group, GTK_OBJECT (toplevel_window));
}

static void Delete(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_clist_freeze(GTK_CLIST(picture_list));

	while(GTK_CLIST(picture_list)->selection)
	{
		gtk_clist_remove (GTK_CLIST(picture_list) , 
			GPOINTER_TO_INT (GTK_CLIST(picture_list)->selection->data));
	}
	
	gtk_clist_thaw(GTK_CLIST(picture_list));
	changed_list = TRUE;
}


static void UnSelect(object , func_data)
GtkObject *object;
gpointer func_data;
{
	gtk_clist_unselect_all(GTK_CLIST(picture_list));
}

static gint list_events (widget , event)
GtkWidget *widget;
GdkEvent  *event;
{
	GdkEventButton *bevent;

	switch (event->type)
	{
	    case GDK_BUTTON_PRESS:
		bevent = (GdkEventButton *) event;
		if (bevent->button == 3)
		{
			gtk_menu_popup (GTK_MENU(list_menu), 
				NULL, NULL, NULL, NULL, 3, bevent->time);
		}
		break;
	    default:
		break;
	}

	return FALSE;
}

static void window_drop_str(widget , context , x , y , seldata , info , time , data)
GtkWidget *widget;
GdkDragContext *context;
gint x;
gint y;
GtkSelectionData *seldata;
guint info;
guint time;
gpointer data;
{
	gchar *p;
	gchar *drag_str;
	gchar *p_seldata;

	if (!seldata || !seldata->data) 
	{
		gtk_drag_finish(context, FALSE, FALSE, time);
		return;
	}

	p_seldata = (gchar *) seldata->data;

	/* strip away '\n' */
	p = strchr(p_seldata , '\n');
	if (p)
		drag_str = g_strndup(p_seldata , p - p_seldata); 	
	else
		drag_str = g_strdup(p_seldata);

	gtk_clist_append(GTK_CLIST(picture_list) , (gchar **)&drag_str);

	g_free(drag_str);

	gtk_drag_finish(context, TRUE, FALSE, time);
}

static void ToggleBool(w , fdata)
GtkWidget *w;
gpointer fdata;
{
	gtk_widget_set_sensitive(GTK_WIDGET(fdata) ,GTK_TOGGLE_BUTTON(w)->active);
}

void build_picture_list(notebook)
GtkWidget *notebook;
{
	GtkWidget *box , *label , *swin , *mi , *button , *pbox;
	GSList *ptr;
	gint row;

	box = gtk_vbox_new (FALSE , 5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Picture list"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	swin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (swin),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (swin);
	gtk_box_pack_start(GTK_BOX(box) , swin , TRUE , TRUE , 1);


	picture_list = gtk_clist_new(1);
	gtk_clist_set_selection_mode(GTK_CLIST(picture_list) , GTK_SELECTION_EXTENDED);
	gtk_clist_set_column_title (GTK_CLIST(picture_list), 0 , 
			gettext("Background pictures"));
	gtk_clist_column_titles_show (GTK_CLIST(picture_list));
	gtk_clist_set_column_auto_resize (GTK_CLIST (picture_list), 0 , TRUE);
	gtk_signal_connect (GTK_OBJECT (picture_list), "button_press_event",
			(GtkSignalFunc) list_events,
			(gpointer)picture_list);
	gtk_container_add (GTK_CONTAINER (swin), picture_list);

  	gtk_drag_dest_set(picture_list, GTK_DEST_DEFAULT_ALL,
			dragtypes , sizeof(dragtypes)/sizeof(dragtypes[0]) ,
               		GDK_ACTION_COPY | GDK_ACTION_MOVE);
  	gtk_signal_connect(GTK_OBJECT(picture_list) ,
			"drag_data_received" ,
			GTK_SIGNAL_FUNC(window_drop_str),
			NULL);

	ptr = cfg.pics;
	while(ptr)
	{
		picentry *pe = ptr->data;

		row = gtk_clist_append(GTK_CLIST(picture_list) , (gchar **)&pe->name);

		if (pe->prop)
			gtk_clist_set_row_data_full(GTK_CLIST(picture_list) , row ,
				g_memdup(pe->prop , sizeof(propt)) , g_free);
									
		ptr = ptr->next;
	}
	gtk_widget_show(picture_list);

	list_menu =  gtk_menu_new();
	gtk_widget_realize (list_menu);

	mi = gtk_menu_item_new_with_label(gettext("Set Properties"));
	gtk_menu_append(GTK_MENU(list_menu) , mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PropDlg) , 
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Delete selected"));
	gtk_menu_append(GTK_MENU(list_menu) , mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(Delete) , 
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Select All"));
	gtk_menu_append(GTK_MENU(list_menu) , mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(SelectAll) , 
			(gpointer)picture_list);

	mi = gtk_menu_item_new_with_label(gettext("Unselect"));
	gtk_menu_append(GTK_MENU(list_menu) , mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(UnSelect) , 
			(gpointer)NULL);

	mi = gtk_menu_item_new_with_label(gettext("Preview focused"));
	gtk_menu_append(GTK_MENU(list_menu) , mi);
	gtk_widget_show (mi);
	gtk_signal_connect(GTK_OBJECT(mi) , "activate" , 
			GTK_SIGNAL_FUNC(PreviewDlg) , (gpointer)NULL);

	pbox = gtk_hbox_new(FALSE , 1);

	recurse = gtk_check_button_new_with_label(gettext("Recurse through directories"));
	gtk_box_pack_start(GTK_BOX(box) , recurse , FALSE , TRUE , 1);
	gtk_widget_show(recurse);

	gtk_signal_connect(GTK_OBJECT(recurse) , "toggled" , 
			GTK_SIGNAL_FUNC(ToggleBool) , (gpointer)pbox);

	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Pattern for recursion: "));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 1);
	gtk_widget_show(label);

	patternw = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(pbox) , patternw , TRUE , TRUE , 1);
	gtk_widget_show(patternw);

	button = gtk_button_new_with_label(gettext("Append"));
	gtk_box_pack_start(GTK_BOX(box) , button , FALSE , TRUE , 1);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(AppendDlg) , 
			(gpointer)NULL);

}

static GtkWidget * toolbar_button(parent , label , help , pmap_data , cb , cb_data)
GtkWidget *parent;
char *label;
char *help;
char **pmap_data;
GtkSignalFunc cb;
gpointer cb_data;
{
	GtkWidget *button = NULL;
	GtkWidget *pixmap = NULL;
	GdkPixmap *pmap;
	GdkBitmap *shape;

	if (pmap_data)
	{
		pmap = gdk_pixmap_create_from_xpm_d(GDK_ROOT_PARENT() , &shape , NULL , pmap_data);
		pixmap = gtk_pixmap_new(pmap , shape);
	}

	button = gtk_toolbar_append_item(GTK_TOOLBAR(parent) , label , 
		help , "" , pixmap , cb  , cb_data);

	return button;
}

void build_toolbar(col)
GtkWidget *col;
{
	GtkWidget *tb , *hbox, *button;

	hbox = gtk_handle_box_new ();
	gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(hbox) , GTK_SHADOW_NONE);
	gtk_box_pack_start(GTK_BOX(col) , hbox , FALSE , TRUE , 0);
	gtk_widget_show(hbox);
	
	tb = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL , GTK_TOOLBAR_BOTH);
	gtk_toolbar_set_button_relief(GTK_TOOLBAR(tb) , GTK_RELIEF_NONE);
	gtk_container_add(GTK_CONTAINER(hbox) , tb);
	gtk_toolbar_set_space_size (GTK_TOOLBAR (tb), 15);
	gtk_widget_show (tb);

	gtk_toolbar_append_space (GTK_TOOLBAR(tb));

	button = toolbar_button(tb , NULL , gettext("Open scenario") ,
			stock_open_xpm , LoadScn , NULL);

	button = toolbar_button(tb , NULL , gettext("Save scenario") , 
			stock_save_as_xpm , SaveScn , NULL);

	button = toolbar_button(tb , NULL , gettext("Apply setup changes") , 
			stock_apply_xpm , ApplyChanges , NULL);

	gtk_toolbar_append_space (GTK_TOOLBAR(tb));

	button = toolbar_button(tb , NULL , gettext("Run with actual settings") ,
			stock_exec_xpm , Run , NULL);

	button = toolbar_button(tb , NULL , gettext("Hide Setup window and run with actual settings") ,
			stock_exec_term_xpm , RunTerm , NULL);

	button = toolbar_button(tb , NULL , gettext("Stop changing pictures") ,
			stock_stop_xpm , Stop , NULL);

	button = toolbar_button(tb , NULL , gettext("Immediately quit") ,
			stock_exit_xpm , QuitReal , NULL);

}

static void build_propt(box , prop , intervalw , max_groww , max_sizew , typew , backgroundw , background_enw , color_chose_func , background2w , background2_enw , color_chose_func2 , efectw , shaderw, rand_colorsw)
GtkWidget *box;
propt *prop;
GtkWidget **intervalw;
GtkWidget **max_groww;
GtkWidget **max_sizew;
GtkWidget **typew;
GtkWidget **backgroundw;
GtkWidget **background_enw;
GtkSignalFunc color_chose_func;
GtkWidget **background2w;
GtkWidget **background2_enw;
GtkSignalFunc color_chose_func2;
GtkWidget **efectw;
GtkWidget **shaderw;
GtkWidget **rand_colorsw;
{
	GtkWidget *frame , *pbox , *label , *chb , *button,*mmenu,*mi;
	GtkAdjustment *adj;
	GSList *rg;
	guint i;

	*rand_colorsw = gtk_check_button_new_with_label(gettext("Randomize background colors"));
	gtk_box_pack_start(GTK_BOX(box) , *rand_colorsw , FALSE , TRUE , 1);
	gtk_widget_show(*rand_colorsw);

	pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Background color :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(pbox) , frame , TRUE , TRUE , 5);

	*backgroundw = gtk_preview_new (GTK_PREVIEW_COLOR);
	gtk_preview_set_dither (GTK_PREVIEW (*backgroundw), GDK_RGB_DITHER_NONE);
	gtk_preview_size (GTK_PREVIEW (*backgroundw), 100 , 20);
	gtk_preview_set_expand (GTK_PREVIEW (*backgroundw), TRUE);
	gtk_container_add(GTK_CONTAINER(frame) , *backgroundw);
	gtk_widget_show(*backgroundw);

	*background_enw = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(pbox) , *background_enw , FALSE , TRUE , 5);
	gtk_widget_show(*background_enw);

	button = gtk_button_new_with_label(gettext("Choose"));
	gtk_box_pack_start(GTK_BOX(pbox) , button , FALSE , TRUE , 1);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(color_chose_func) , NULL);

	pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Background color2 :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	frame = gtk_frame_new(NULL);
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX(pbox) , frame , TRUE , TRUE , 5);

	*background2w = gtk_preview_new (GTK_PREVIEW_COLOR);
	gtk_preview_set_dither (GTK_PREVIEW (*background2w), GDK_RGB_DITHER_NONE);
	gtk_preview_size (GTK_PREVIEW (*background2w), 100 , 20);
	gtk_preview_set_expand (GTK_PREVIEW (*background2w), TRUE);
	gtk_container_add(GTK_CONTAINER(frame) , *background2w);
	gtk_widget_show(*background2w);

	*background2_enw = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(pbox) , *background2_enw , FALSE , TRUE , 5);
	gtk_widget_show(*background2_enw);

	button = gtk_button_new_with_label(gettext("Choose"));
	gtk_box_pack_start(GTK_BOX(pbox) , button , FALSE , TRUE , 1);
	gtk_widget_show(button);
	gtk_signal_connect(GTK_OBJECT(button) , "clicked" , 
			GTK_SIGNAL_FUNC(color_chose_func2) , NULL);

        pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Background shading efect :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	*shaderw = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(pbox) , *shaderw , FALSE , TRUE , 5);
	mmenu = gtk_menu_new();
	for (i = 0 ; i <= NUM_SHADERS ; i++)
	{
		char pom[100];

		if (i == 0)
			sprintf(pom , "%s" ,  gettext("None"));
		else if (i == 1)
			sprintf(pom , "%s" ,  gettext("Random"));
		else
			sprintf(pom , "%d" , i);
		mi = gtk_menu_item_new_with_label(pom);
		gtk_object_set_user_data(GTK_OBJECT(mi) , (gpointer)i);
		gtk_menu_append (GTK_MENU (mmenu), mi);
		gtk_widget_show(mi);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU (*shaderw) , mmenu);
	gtk_option_menu_set_history(GTK_OPTION_MENU(*shaderw) , prop->shade);
	gtk_widget_show(*shaderw);

	pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Interval :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)prop->interval, 0.01,
				1000000.0, 1.0, 60.0, 0.0);
	*intervalw = gtk_spin_button_new(adj , 0 , 2);
	gtk_widget_set_usize(*intervalw , 
		gdk_string_width((*intervalw)->style->font , "wwwwww") , -1);
	gtk_box_pack_start(GTK_BOX(pbox) , *intervalw , FALSE , TRUE , 5);
	gtk_widget_show (*intervalw);

	label = gtk_label_new(gettext("minutes"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

        pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Picture changing efect :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	*efectw = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(pbox) , *efectw , FALSE , TRUE , 5);
	mmenu = gtk_menu_new();
	for (i = 0 ; i <= NUM_EFECTS ; i++)
	{
		char pom[100];
		if (i == 1)
			sprintf(pom , "%s" ,  gettext("None"));
		else if (i == 0)
			sprintf(pom , "%s" ,  gettext("Random"));
		else
			sprintf(pom , "%d" , i);
		mi = gtk_menu_item_new_with_label(pom);
		gtk_object_set_user_data(GTK_OBJECT(mi) , (gpointer)i);
		gtk_menu_append (GTK_MENU (mmenu), mi);
		gtk_widget_show(mi);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU (*efectw) , mmenu);
	gtk_option_menu_set_history(GTK_OPTION_MENU(*efectw) , prop->efect);
	gtk_widget_show(*efectw);

	frame = gtk_frame_new(gettext("Rendering Mode"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX (box), frame , TRUE, TRUE, 5);

	pbox = gtk_vbox_new(FALSE , 2);
	gtk_container_add(GTK_CONTAINER(frame) , pbox);
	gtk_widget_show(pbox);
	
	rg = NULL;

	chb = gtk_radio_button_new_with_label(rg , gettext("Tile picture"));
	rg = gtk_radio_button_group (GTK_RADIO_BUTTON (chb));
	gtk_object_set_user_data(GTK_OBJECT(chb) , (gpointer)TILE);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chb) , prop->type == TILE);
	gtk_box_pack_start(GTK_BOX(pbox) , chb , FALSE , TRUE , 1);
	gtk_signal_connect(GTK_OBJECT(chb) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)&prop->type);
	gtk_widget_show(chb);
	typew[TILE] = chb;

	chb = gtk_radio_button_new_with_label(rg , gettext("Tile mirrored picture"));
	rg = gtk_radio_button_group (GTK_RADIO_BUTTON (chb));
	gtk_object_set_user_data(GTK_OBJECT(chb) , (gpointer)MIRROR);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chb) , prop->type == MIRROR);
	gtk_box_pack_start(GTK_BOX(pbox) , chb , FALSE , TRUE , 1);
	gtk_signal_connect(GTK_OBJECT(chb) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)&prop->type);
	gtk_widget_show(chb);
	typew[MIRROR] = chb;

	chb = gtk_radio_button_new_with_label(rg , gettext("Maximize picture"));
	rg = gtk_radio_button_group (GTK_RADIO_BUTTON (chb));
	gtk_object_set_user_data(GTK_OBJECT(chb) , (gpointer)MAXIMIZE);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chb) , prop->type == MAXIMIZE);
	gtk_box_pack_start(GTK_BOX(pbox) , chb , FALSE , TRUE , 1);
	gtk_signal_connect(GTK_OBJECT(chb) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)&prop->type);
	gtk_widget_show(chb);
	typew[MAXIMIZE] = chb;

	chb = gtk_radio_button_new_with_label(rg , gettext("Center picture"));
	rg = gtk_radio_button_group (GTK_RADIO_BUTTON (chb));
	gtk_object_set_user_data(GTK_OBJECT(chb) , (gpointer)CENTER);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chb) , prop->type == CENTER);
	gtk_box_pack_start(GTK_BOX(pbox) , chb , FALSE , TRUE , 1);
	gtk_signal_connect(GTK_OBJECT(chb) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)&prop->type);
	gtk_widget_show(chb);
	typew[CENTER] = chb;

	chb = gtk_radio_button_new_with_label(rg , gettext("Smart resized centered picture"));
	rg = gtk_radio_button_group (GTK_RADIO_BUTTON (chb));
	gtk_object_set_user_data(GTK_OBJECT(chb) , (gpointer)MAX_ASP_RATIO_CENTER);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(chb) , prop->type == MAX_ASP_RATIO_CENTER);
	gtk_box_pack_start(GTK_BOX(pbox) , chb , FALSE , TRUE , 1);
	gtk_signal_connect(GTK_OBJECT(chb) , "toggled" , 
			GTK_SIGNAL_FUNC(SwitchMode) , 
			(gpointer)&prop->type);
	gtk_widget_show(chb);
	typew[MAX_ASP_RATIO_CENTER] = chb;

	frame = gtk_frame_new(gettext("Smart rendering mode setup"));
	gtk_widget_show(frame);
	gtk_box_pack_start(GTK_BOX (box), frame , TRUE, TRUE, 5);

	box = gtk_vbox_new(FALSE , 2);
	gtk_container_add(GTK_CONTAINER(frame) , box);
	gtk_widget_show(box);

	pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Max grow ratio for picture :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new (prop->max_grow, 0.0, 1000.0, 0.1,
					1.0, 0.0);
	*max_groww = gtk_spin_button_new(adj , 0 , 1);
	gtk_widget_set_usize(*max_groww , 
		gdk_string_width((*max_groww)->style->font , "wwwwww") , -1);
	gtk_box_pack_start(GTK_BOX(pbox) , *max_groww , FALSE , TRUE , 5);
	gtk_widget_show (*max_groww);

	pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Maximal size of screen taken by picture :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)prop->max_size, 
			10.0, 100.0, 1.0, 5.0, 0.0);
	*max_sizew = gtk_spin_button_new(adj , 0 , 0);
	gtk_widget_set_usize(*max_sizew , 
		gdk_string_width((*max_sizew)->style->font , "wwwwww") , -1);
	gtk_box_pack_start(GTK_BOX(pbox) , *max_sizew , FALSE , TRUE , 5);
	gtk_widget_show (*max_sizew);

	label = gtk_label_new(gettext("%"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);
}

void build_setup(notebook)
GtkWidget *notebook;
{
	GtkWidget *box , *label , *pbox;
	GtkAdjustment *adj;

	box = gtk_vbox_new (FALSE , 5);
	gtk_widget_show(box);
	label = gtk_label_new (gettext("Setup"));
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box , label);

	randomized = gtk_check_button_new_with_label(gettext("Randomize picture order"));
	gtk_box_pack_start(GTK_BOX(box) , randomized , FALSE , TRUE , 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(randomized) , cfg.randomize);
	gtk_widget_show(randomized);

	blank = gtk_check_button_new_with_label(gettext("Show blank screen when can't load picture"));
	gtk_box_pack_start(GTK_BOX(box) , blank , FALSE , TRUE , 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(blank) , cfg.blank);
	gtk_widget_show(blank);

	screensaver = gtk_check_button_new_with_label(gettext("Act as screensaver"));
	gtk_box_pack_start(GTK_BOX(box) , screensaver , FALSE , TRUE , 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(screensaver) , cfg.screensaver);
	gtk_widget_show(screensaver);

	inwindow = gtk_check_button_new_with_label(gettext("Run in own window"));
	gtk_box_pack_start(GTK_BOX(box) , inwindow , FALSE , TRUE , 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(inwindow) , cfg.inwindow);
	gtk_widget_show(inwindow);

	cycle_blank = gtk_check_button_new_with_label(gettext("Cycle blank screens"));
	gtk_box_pack_start(GTK_BOX(box) , cycle_blank , FALSE , TRUE , 1);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cycle_blank) , cfg.cycle_blank);
	gtk_widget_show(cycle_blank);

	pbox = gtk_hbox_new(FALSE , 2);
	gtk_box_pack_start(GTK_BOX(box) , pbox , FALSE , TRUE , 1);
	gtk_widget_show(pbox);

	label = gtk_label_new(gettext("Picture changing speed ratio :"));
	gtk_box_pack_start(GTK_BOX(pbox) , label , FALSE , TRUE , 5);
	gtk_widget_show(label);

	adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat)cfg.speed, 
			0.0, 1000000.0, 10.0, 100.0, 0.0);
	speed = gtk_spin_button_new(adj , 0 , 0);
	gtk_widget_set_usize(speed , 
		gdk_string_width((speed)->style->font , "wwwwwwwww") , -1);
	gtk_box_pack_start(GTK_BOX(pbox) , speed , FALSE , TRUE , 5);
	gtk_widget_show (speed);

	build_propt(box , &cfg.properties , &interval , &max_grow , &max_size , type , &background , &background_en , ColorDlg, &background2 , &background2_en , ColorDlg2, &efect, &shader, &rand_colors);
}

void run_setup(argc , argv)
guint *argc;
gchar ***argv;
{
	GtkWidget *col, *notebook , *sep;

	gtk_init(argc , argv);

	toplevel_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(toplevel_window) , gettext("ChBg setup"));
	gtk_signal_connect (GTK_OBJECT (toplevel_window), "destroy",
		GTK_SIGNAL_FUNC(Quit), NULL);
	
	col = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(toplevel_window) , col);
	gtk_widget_show(col);

	build_menu(col);

	sep = gtk_hseparator_new();
	gtk_widget_show(sep);
	gtk_box_pack_start(GTK_BOX (col), sep , FALSE, TRUE, 1);

	build_toolbar(col);

	notebook = gtk_notebook_new ();
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(col) , notebook , TRUE , TRUE , 1);
	gtk_widget_show (notebook);

	build_setup(notebook);
	build_picture_list(notebook);

	gtk_widget_show(toplevel_window);	
	set_cfg();

	if (cfg.runit)
		Run(NULL);

	gtk_main();

	if (toplevel_window)
	{
		get_cfg();
 		gtk_widget_destroy(toplevel_window);
	}
}
