/*
 * timing.c: Timing functions for XTux.
 * Copyright 1999 David Lawrence (philaw@camtech.net.au)
 * Last modified July 26
 */

#include <sys/time.h>
#include "header.h"
#include "timing.h"

/* Delay for i microseconds, returns seconds paused. */
int delay(unsigned int i)
{
  
  struct timeval timeout;
  
  if( i ) {
    timeout.tv_usec =  i % (unsigned long) M_SEC;
    timeout.tv_sec  =  i / (unsigned long) M_SEC;
    select(0, NULL, NULL, NULL, &timeout);
    return i;
  }

  return 0;

}

/* Return the difference in microseconds between st and current time */
int time_diff(struct timeval rt, struct timeval st)
{

  return 1000000 * (rt.tv_sec - st.tv_sec) + rt.tv_usec - st.tv_usec;

}

