//
// $Id: chest.pov,v 1.1 1999/03/27 07:29:53 xblast Exp $
// $Log: chest.pov,v $
// Revision 1.1  1999/03/27 07:29:53  xblast
// Initial revision
//
//
#include "BLGeneric.inc"

#declare R=1.2
#declare H=1.2
#declare DR=0.05

#declare myDull = finish {ambient 0.2 specular 0.25 roughness 0.40}

#declare nagel = 
sphere {
  <0,0,0>, 1
  scale <0.1,0.1,0.05>
  pigment {color rgb <0,0.667,0>}
  finish {Shiny metallic}
}

union {
  // beschlaege
  difference {
    merge {
      box {
        <-1.95,0,-2>
        < 1.95,H,-2+2*R>
      }
      cylinder {  
        <-1.95,H,-2+R>
        < 1.95,H,-2+R>
        R
      }
    }
    merge {
      box { 
       <-1.60,H+0.125,-2>
       < 1.60,4.000,  +2>
      }
      box { 
       <-1.60,  0.125,-2.25>
       < 1.60,H-0.125,  +2.25>
      }
      box {
        <-2.1,H-0.05,-2.25>
        < 2.1,H+0.05,+2.25>
      }
    }
  }
  // naegel
  union {
    object {nagel translate <-1.8,  H/4,-2>}
    object {nagel translate <-1.8,3*H/4,-2>}
    object {nagel translate < 1.8,  H/4,-2>}
    object {nagel translate < 1.8,3*H/4,-2>}
    #declare winkel=15
    #while (winkel <180)
      object {
        nagel 
        translate <-1.8, 0, -R> 
        rotate x*winkel 
        translate <0,H,R-2>
      }
      object {
        nagel 
        translate <1.8, 0, -R> 
        rotate x*winkel 
        translate <0,H,R-2>
      }
      #declare winkel=winkel+30
    #end
  }
  // lock etc
  union {
    box {
      <-0.125,H+0.125,-1.8>
      < 0.125,H-0.375,-2.05>
    }  
    cylinder {
      <-0.05,H-0.25,-2.05>
      < 0.05,H-0.25,-2.05>
      0.1
    }
    union {
       cylinder {
         <0.0,H-0.35,-2.05>
         <0.0,H-0.35,-2.15>
         0.2
       }
       superellipsoid {
         <0.33,0.33>
         scale <0.3,0.3,0.1>
         translate <0.0,H-0.65,-2.10>
       }
      pigment {color rgb <0,0.6,0>}
      finish {Shiny metallic}
    }
  }
  pigment {color rgb <0,1,0>}
  finish {Shiny metallic}
  normal {dents 0.75 scale 0.2}
}


union {
  box {
    <-2.0+DR, 0.000, -2    +DR>
    < 2.0-DR, H,     -2+2*R-DR>
    normal { 
      gradient x
      slope_map {
        [0.0 0.0] [0.1 1.0] [0.9 1.0] [1.0 0.0]
      }
      scale 0.667
    }
    pigment {
      gradient x
      color_map {
        [0.0 color rgb <1.00,0,0>]
        [1.0 color rgb <0.50,0,0>]
      }
      scale 0.133
      turbulence 0.25
    }
    finish {myDull}
  }
 
  cylinder {  
    <-2+DR,0,0>
    < 2-DR,0,0>
    R-DR
    normal { 
      radial
      slope_map {
        [0.0 0.0] [0.1 1.0] [0.9 1.0] [1.0 0.0]
      }
      frequency 12
      rotate z*90
    }
    pigment {
      radial
      color_map {
        [0.0 color rgb <1.00,0,0>]
        [1.0 color rgb <0.50,0,0>]
      }
      frequency 60
      rotate z*90
      turbulence 0.25
    }
    finish {myDull}
    translate <0,H,-2+R>
  }
}
