//
// $Id$
// $Log$
//
//
// pov include file for rendering all block tiles
//
#include "colors.inc"
#include "textures.inc"

#declare myDull = finish {ambient 0.2 specular 0.25 roughness 0.40}
#declare myShiny = finish {ambient 0.2 specular 0.75 roughness 0.0125}


// background (sky) color
background {color SkyBlue}
plane {y, -1 pigment{color Black} }

// unity cube
#declare cubeOne = 
box {
  <-1,-1,-1>, <1,1,1>
}

// cracked extra
#declare normalCracked =
normal { 
  crackle 
  slope_map {
    [0.0 0.0]
    [0.1 1.0]
    [1.0 1.0]
  }
}



// light source
light_source {
  <-100,500,-250>
  color rgb <1.2,1.2,1.2>
}

// camera
#declare Entf = 500.0
camera
{
  location  <0, 0, -Entf>
  direction <0, 0,  Entf>
  up        3.0*y
  right     4.0*x
  look_at   <0.0, 0.0, 0.0>
  rotate x*48.60
}
