///////////////////////////////////////////////////////////////////////////////
// $Id: DeckMoveCommand.hxx,v 1.1 1995/01/08 06:41:34 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// DeckMoveCommand.hxx - Command called when a deck has been split and moved
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: DeckMoveCommand.hxx,v $
// Revision 1.1  1995/01/08  06:41:34  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef DECKMOVECOMMAND_HXX
#define DECKMOVECOMMAND_HXX

#include "Command.hxx"
#include "Engine.hxx"
#include "Deck.hxx"

class DeckMoveCommandArguments {
  public:
    Deck* from;   // Deck the cards were moved from
    Deck* moved;  // Plain deck the user moved around

    DeckMoveCommandArguments(Deck* f, Deck* m)
        : from(f), moved(m)
    { }
};

class DeckMoveCommand : public Command {
  private:
    Engine* myEngine;

  public:
    // Protected constructor to prevent instantiation
    DeckMoveCommand(Engine* engine) { myEngine = engine; }

    // Destructor
    virtual ~DeckMoveCommand() { }

    // Tell the engine to handle moving the cards
    virtual void execute(void* argument)
    {
      DeckMoveCommandArguments* args = (DeckMoveCommandArguments*)argument;
      myEngine->moveCards(args->from, args->moved);
    }
};

#endif

