/*C* $Id: debug.cc,v 1.1 1997/09/25 20:02:09 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#include "debug.h"

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#ifndef NDEBUG
int vdebug = 0;
#endif

extern "C" void nonFatal(const char* format, ...)
{
 va_list ap;
 va_start(ap, format);
 vfprintf(stderr, format, ap);
 va_end(ap);
 fflush(stderr);
}

extern "C" void fatal(const char *format, ...)
{
 va_list ap;
 va_start(ap, format);
 vfprintf(stderr, format, ap);
 va_end(ap);
 fflush(stderr);
 exit(EXIT_FAILURE);
}
