/*C* $Id: gluetext.h,v 1.4 1997/08/11 23:15:22 james Exp $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef src_gluetext_h
#define src_gluetext_h

#include "../gl/Point.h"
#include "../util/Collection.h"
#include "../util/Object.h"

class GlueText : public Object
{
public:
 GlueText(Point _p, int _time, const char* format, ...);
 ~GlueText() { delete text; }
private:
 Point p;
 char* text;
 int time;
 friend class GlueTextManager;
};

class GlueTextManager
{
public:
 GlueTextManager(class Font* _font);
 ~GlueTextManager();
 void add(class GlueText* gt) { glueTexts->add(gt); }
 void blur(class VgaBlur* vc);
 void tick();
private:
 Collection<GlueText>* glueTexts;
 class Font* font;
};

#endif

