/*C* $Id: game.h,v 1.7 1997/09/26 17:55:49 james Exp james $
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef src_Game_h
#define src_Game_h

#include "Dir.h"
#include "Ghost.h"
#include "Pos.h"
#include "../util/Collection.h"

#include <stdlib.h>
#include <sys/time.h>

class Game
{
public:
 Game();
 ~Game();
 
 bool playerCanMove(Dir dir);
 bool ghostCanMove(int i, Dir dir);
 bool fruitCanMove(Dir dir);
 void drawScoreBox();
 void kill();
 void draw();

 void moveGhosts(int ticks);
 void movePlayer(int ticks);
 void moveFruit(int ticks);
 void checkInput();
 void mainLoop();

 bool play();

 //bool playLevel(const char* filename);
 //bool playLevel(const class Level* _level);
 //bool playGame(const char* filename);

private:
 class GlueTextManager* gtm;
 Pos base;
 Rect scoreRect;
 class Level* level;
 class Player* player;
 class Fruit* fruit;
 bool fruitActive;
 Dir fruitDir;
 Collection<Pos>* fruitStarts;
 bool quit;
 Collection<Ghost>* ghosts;
 int power, ghostScore;
 class LevelOptions* levelOptions;
 class SpeedControl *playerSpeed, *playerSlowSpeed, *ghostSpeed, *ghostScaredSpeed, *ghostEyesSpeed, *fruitSpeed;
 class Ticker* ticker;

 // graphics

 class Aset *hatmanAset, *ghostAset, *fruitAset;

private:
 class GameItems* gameItems;

 void initGame();

public:
 bool loadGame(const char* filename);
 bool playGame();
};

extern Game* game;

#endif
