
BEGIN {
  print("#ifndef gl_keycodes_h");
  print("#define gl_keycodes_h");
}

/\#.*/ {
  print($0);
}

/[0-9]+ [A-Z0-9]+/ {
  for(a = 2; a<=NF; a++) {
    print("#define KEY_"$(a)" "$1);
    print("#define IS_KEY_"$(a)"(i) ((i)==KEY_"$(a)")");
  }
}

/[A-Z][0-9]* [A-Z0-9]+/ {
  ik = "#define IS_KEY_"$1"(i) (";
  for(a = 2; a<=NF; a++) {
    if(a != 2) { ik = ik " || "; }
    ik = ik "IS_KEY_"$(a)"(i)";
  }
  ik = ik ")";
  print(ik);
}

END {
  print("#endif");
}
