/* Groundhog -- a simple logic game
 * Copyright (C) 1998 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <strstream.h>

#include "highscore_tab.h"
#include "score.h"

HighScoreTab::HighScoreTab(GtkWidget* notebook, const char* tab_name)
{
   GtkWidget* table = gtk_table_new(10, 3, TRUE);

   // Create header
   GtkWidget* label = gtk_label_new("Rank");
   gtk_widget_show(label);
   gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
   
   label = gtk_label_new("Name");
   gtk_widget_show(label);
   gtk_table_attach_defaults(GTK_TABLE(table), label, 1, 2, 0, 1);
   
   label = gtk_label_new("Seconds");
   gtk_widget_show(label);
   gtk_table_attach_defaults(GTK_TABLE(table), label, 2, 3, 0, 1);

   gtk_widget_show(table);

   for (int i = 1; i <= 10; i++) {
      char scratch[16];
      ostrstream ost(scratch, sizeof(scratch));
      
      ost << i << ends;
      GtkWidget* index_label = gtk_label_new(scratch);
      gtk_widget_show(index_label);
      gtk_table_attach_defaults(GTK_TABLE(table), index_label, 0, 1, i, i + 1);

      _names[i] = gtk_label_new("");
      gtk_widget_show(_names[i]);
      gtk_table_attach_defaults(GTK_TABLE(table), _names[i], 1, 2, i, i + 1);

      _seconds[i] = gtk_label_new("");
      gtk_widget_show(_seconds[i]);
      gtk_table_attach_defaults(GTK_TABLE(table), _seconds[i], 2, 3, i, i + 1);
   }
   
   label = gtk_label_new(tab_name);
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, label);
}

void
HighScoreTab::FillOneScore(int index, const char* name, const char* seconds)
{
   gtk_label_set(GTK_LABEL(_names[index]), name);
   gtk_label_set(GTK_LABEL(_seconds[index]), seconds);
}

void
HighScoreTab::Fill(const ScoreList& slist)
{
   int index = 1;
   for (list<Score>::const_iterator i = slist.Begin(); i != slist.End(); i++) {
      char scratch[16];
      ostrstream ost(scratch, sizeof(scratch));
      
      ost << (*i).GetSeconds() << ends;

      FillOneScore(index++, (*i).GetName().c_str(), scratch);
   }
   
   for (; index <= 10; index++)
      FillOneScore(index, "-", "-");
}
