/*
 * static char *rcsid_decor_ =
 *   "$Id: decor.c,v 1.2 1999/03/20 10:57:22 master Exp $";
 */

/*
    CrossFire, A Multiplayer game for X-windows

    Copyright (C) 1992 Frank Tore Johansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    The author can be reached via e-mail to mark@pyramid.com
*/


#include <global.h>
#include <random_map.h>

#define NR_DECOR_OPTIONS 1

/* return a simple count of objects in the map at x,y. */

int obj_count_in_map(mapstruct *map,int x,int y) {
  int count=0;
  object *tmp;
  for(tmp=get_map_ob(map,x,y);tmp!=NULL;tmp=tmp->above)
	 count++;
  return count;
}
/* put the decor into the map.  Right now, it's very primitive. */

void put_decor(mapstruct *map,char **maze,char *decorstyle,int decor_option) {
  mapstruct *decor_map;
  char style_name[256];

  sprintf(style_name,"/styles/decorstyles");

  decor_map = find_style(style_name,decorstyle,-1);
  if(decor_map == NULL) return;
  /* pick a random option, only 1 option right now. */
  if(decor_option==0) {
    decor_option = RANDOM() % NR_DECOR_OPTIONS +1;
  };
  switch(decor_option) {
  case 1:  /* random placement of decor objects. */
    {
      int number_to_place = RANDOM() % ( (Xsize *Ysize) / 5);
      int failures=0;
      object *new_decor_object;
      while(failures < 100 && number_to_place  > 0) {
		  int x,y;
		  x = RANDOM() % (Xsize-2) +1;
		  y = RANDOM() % (Ysize-2) +1;
		  if(maze[x][y]==0 && obj_count_in_map(map,x,y)<2) /* empty */
			 { 
				object *this_object;
				new_decor_object = pick_random_object(decor_map);
				this_object = arch_to_object(new_decor_object->arch);
				copy_object(new_decor_object,this_object);
				this_object->x = x;
				this_object->y = y;
				/* it screws things up if decor can stop people */
				CLEAR_FLAG(this_object,FLAG_NO_PASS);
				insert_ob_in_map(this_object,map);
				number_to_place--;
			 }
		  else failures++;
      }
      break;

    }	
  }
}
