//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef _STANDARD_HH_
#define _STANDARD_HH_

#include "IntegerType.hh"
#include "RealType.hh"
#include "EnumerationType.hh"
#include "PhysicalType.hh"

extern enumInfo  SavantbitType_info;
extern enumInfo  SavantcharacterType_info;
extern enumInfo  SavantbooleanType_info;
extern enumInfo  Savantseverity_levelType_info;
extern enumInfo  Savantfile_open_kindType_info;
extern enumInfo  Savantfile_open_statusType_info;

extern rangeInfo SavantintegerType_info;
extern rangeInfo SavantnaturalType_info;
extern rangeInfo SavantpositiveType_info;
extern rangeInfo SavantwidthType_info;

extern realInfo  SavantrealType_info;

extern phyInfo   SavanttimeType_info;
extern phyInfo   Savantdelay_lengthType_info;

#include "Savantbit_vectorType.hh"
#include "SavantstringType.hh"

extern const EnumerationType SAVANT_BOOLEAN_TRUE;
extern const EnumerationType SAVANT_BOOLEAN_FALSE;

extern const PhysicalType    SAVANT_ZERO_TIME;
extern const PhysicalType    SAVANT_INFINITY_TIME;

extern const enumInfo        NULL_ENUM_INFO;

#ifndef savantnow
#define savantnow (PhysicalType(ObjectBase::VARIABLE, UniversalLongLongInteger(getTimeNow().time)), SavanttypeTime_info)
#endif

#endif

