#ifndef CWSIGNALTYPE_HH
#define CWSIGNALTYPE_HH
#include "TaggedRecord.hh"
#include "CWSignalData.hh"

class CWSignalType : public VHDLType {
public:

  ObjectBase *object;

  virtual Type get_kind() const {
    return CLASS_WIDE_TYPE;
  }

#ifdef CLASS_WIDE

  // If these are to be compiled, the Signal constructor with an int
  // argument must be commented out of Signal.cc

   CWSignalType(ObjectBase::ObjectType objType);

   CWSignalType(ObjectBase::ObjectType objType, const TaggedRecord& value);
  
   CWSignalType(ObjectBase::ObjectType objType, const CWSignalType& value);

   CWSignalType(ObjectBase::ObjectType objType, const CWSignalData & value);
#endif

  virtual ~CWSignalType() {};

  virtual bool operator == (const VHDLType&);

  virtual void print(ostream& os) const;

  virtual VHDLType* clone() const;

  virtual ObjectBase::ObjectType getKind() const;

  virtual ObjectBase* getObject() const;

};

#endif


