#include "VHDLKernel_state.hh"
#include "VHDLType.hh"
#include "Block.hh"
#include "AccessType.hh"
#include "Wait.hh"
#include "VHDLKernel.hh"

// tyVis needs the new style of state saving mechanism of warped to implement
// types defined using generic constants etc. The information about these
// constants is available in the elab-class of the process to which the
// state belongs. This elab class pointer is available as part of the state
// that pointer will be used to copy the information from the elab class to
// to a set of global objects and the types will be based off those values
// of global constants.

VHDLKernel_state::VHDLKernel_state(){}

VHDLKernel_state::~VHDLKernel_state() {
  // In case the process's state has access types then the
  // object pointed to by the access types are deleted here
  // This is being done as one object can be pointed to by
  // many access types! - TV
//   int elements = AccessType::accessedObjectList.getNumberOfElements();
//   for (int i = 0; i < elements; i++) {
//     delete (VHDLType*)AccessType::accessedObjectList[i];
//   }
//   AccessType::accessedObjectList.reset();

  delete [] wait;
}

void
VHDLKernel_state::initState(_savant_entity_elab*, VHDLKernelBase*) {
  waitLabel = -1;
  waitExpired = true;
}

VHDLKernel_state&
VHDLKernel_state::operator=(VHDLKernel_state &s) {
  (BasicState&)*this = (BasicState&)s;

//   numWaits = s.numWaits;
  stack = s.stack;
  procWait = s.procWait;
  waitLabel = s.waitLabel;
  waitTime = s.waitTime;
  waitExpired = s.waitExpired;
  return *this;
}

// The set of functions needed for the new style of state saving in
// warped kernel. This new style is needed to handle types defined using
// generic constants etc.

void
VHDLKernel_state::copyState( BasicState* operand ) {
  *this = *((VHDLKernel_state *) operand);
}

int
VHDLKernel_state::getSize() const {
  cerr << "Error :: VHDLKernel_state::getSize() called" << endl;
  abort();

  return -1;
}

void
VHDLKernel_state::serialize(ofstream *, int) {
  cerr << "Error :: VHDLKernel_state::serialize(ofstream *, int) called\n";
  abort();
}

void
VHDLKernel_state::deserialize(ifstream *) {
  cerr << "Error :: VHDLKernel_state::deserialize(ifstream *) called\n";
  abort();
}

void
VHDLKernel_state::deserialize(ifstream *inFile, SimulationObj *simObj) {
  VHDLKernel *base;
  ASSERT ( simObj != NULL );
  base = (VHDLKernel *) simObj;
  initState(base->proc, base);
  deserialize(inFile);
}
