#ifndef SIGNAL_HH
#define SIGNAL_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: Signal.hh,v 1.26 1999/03/09 22:52:12 dmartin Exp $
//
//---------------------------------------------------------------------------
#include "SignalBase.hh"

class SourceBase;
class VHDLKernelBase;

template <class Type> 
class Signal : public SignalBase {
public:
  inline Signal();
  inline Signal(const VHDLData&);
  //  inline Signal(const char*);
  inline Signal(const Signal&);
  inline Signal(const int);
  //  Signal(const char);
  //  Signal(const bool);
  //  Signal(const double);
  inline ~Signal();

  inline bool _is_resolved() const {
    return INT_TO_BOOL(source->getResolutionFnId() != DEFAULT_ID);
  }

  virtual inline ObjectType getKind() const {return SIGNAL;}
  inline ObjectBase& operator=(const ObjectBase&);
  inline ObjectBase& operator=(const VHDLData&);
  inline Signal<Type>& operator=(const Signal<Type>& rhs) {
    this->operator=((const ObjectBase &) rhs);
    return *this;
  }
  
  inline void print(ostream&) const;
  inline void updateDriver(const int, const int, VHDLData*, const ArrayInfo*, 
		    const ArrayInfo* = NULL);
  inline void disconnectDriver(const int);

  inline VHDLType* readDriver(int);
  inline void updateDrvVal(const VHDLData*, const ArrayInfo* = NULL, 
		    const ArrayInfo* = NULL);
  inline VHDLData* readDrvVal();
  virtual inline void updateEffVal(const VHDLData&, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  virtual inline void updateEffVal(const VHDLData*, const ArrayInfo* = NULL,
		    const ArrayInfo* = NULL);
  inline VHDLData* readEffVal();
  inline FanDest_t* getFanList();

  //Number of sources will be fixed in initState() after dynamic elaboration
  SourceBase* source;	// sources for this signal
                        // if numSources > 1, busResFn must be valid
  Type drvVal;          // driving value of the signal
  Type effVal;          // effective value of the signal

  // a flag to find out whether to delete the source tree or not.
  // Before type conversion was implemented, the source tree was deleted
  // by the SignalNetinfo. But now, they are loosing the tree, so this
  // way
  bool sourceBaseDeleteFlag;

  const VHDLData& readVal() const {
    return ((VHDLData&) effVal);
  }

  virtual inline void updateVal(const VHDLData& val) {
    updateEffVal((const VHDLData *) &val);
  }

  inline void setSource(SourceBase *src) {
    source = src;
  }

  inline ObjectBase* clone() const {
    Signal<Type> *retval = new Signal<Type>;
    *retval = *this;
    return ((ObjectBase *) retval);
  }

  inline VHDLType* resolve(VHDLKernelBase*);
  bool compositeResolvedSignal;

  inline void setCompositeResolvedSignal(bool val) {
    compositeResolvedSignal = val;
  }

  inline bool isCompositeResolvedSignal() {
    return compositeResolvedSignal;
  }

  virtual SignalBase* findSigInBlock(int sigId, int srcId);

  virtual void set_sourcebase_delete_flag(bool flag) {
    sourceBaseDeleteFlag = flag;
  }
  
  SourceBase* getSource() {
    return source;
  }
};

template <class Type>
ostream& operator << (ostream& os, Signal<Type> sig) {
  os << *sig.readEffVal();
  return os;
}

#include "Signal.cc"
#endif
