#include "standard.hh"
#include "Signal.hh"
#include "ImplicitSignal.hh"
#include "Variable.hh"
#include "SignalNetinfo.hh"
#include "STDTypes.hh"
#include "SavantstringType.hh"

PhysicalType::PhysicalType(ObjectBase::ObjectType objType): ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalLongLongInteger>; break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalLongLongInteger>; break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalLongLongInteger>; break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

PhysicalType::PhysicalType(ObjectBase::ObjectType objType, 
			   const UniversalLongLongInteger& val): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalLongLongInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalLongLongInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalLongLongInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

PhysicalType::PhysicalType(ObjectBase::ObjectType objType, 
			   const PhysicalType& value): 
  ScalarType(objType) {
  UniversalLongLongInteger val = (UniversalLongLongInteger&) value.getVHDLData();
  
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalLongLongInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalLongLongInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalLongLongInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  
  range = value.range;
}

PhysicalType::PhysicalType(bool alias, const PhysicalType& actual) 
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
}

PhysicalType::PhysicalType(const PhysicalType& value): ScalarType(value) {
  range = value.range;
}

//The new constructors
PhysicalType::PhysicalType(ObjectBase::ObjectType objType,
			   const phyInfo& pInfo)
  : ScalarType(objType) {
  UniversalLongLongInteger initialValue(pInfo.get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalLongLongInteger>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalLongLongInteger>(initialValue);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalLongLongInteger>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  range = pInfo;
}

PhysicalType::PhysicalType(ObjectBase::ObjectType objType,
			   const TypeInfo &typeInfo) {

  UniversalLongLongInteger initialValue(((const phyInfo &) typeInfo).get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalLongLongInteger>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalLongLongInteger>(initialValue);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalLongLongInteger>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  range = (const phyInfo &) typeInfo;
}

PhysicalType::PhysicalType(ObjectBase::ObjectType objType, 
			   const UniversalLongLongInteger& val,
			   const phyInfo& pInfo): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalLongLongInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalLongLongInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalLongLongInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  range = pInfo;
}

PhysicalType::PhysicalType(ObjectBase::ObjectType objType, 
			   const PhysicalType& value,
			   const phyInfo& pInfo): 
  ScalarType(objType) {
  UniversalLongLongInteger val = (UniversalLongLongInteger&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalLongLongInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalLongLongInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalLongLongInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  range = pInfo;
}

PhysicalType::PhysicalType(bool alias, const PhysicalType& actual,
			   const phyInfo& pInfo) 
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
  range = pInfo;
}

PhysicalType::PhysicalType(const PhysicalType& value,
			   const phyInfo& pInfo): 
  ScalarType(value) { 
  range = pInfo;
}

PhysicalType&
PhysicalType::operator = (const PhysicalType& value) {
  ((ScalarType &) *this) = (const ScalarType &) value;
  range = (const phyInfo &) value.range;
  return *this;
}
    
Type 
PhysicalType::get_kind() const {
  return PHYSICAL_TYPE;
}

PhysicalType
savantPlus(const PhysicalType& lhs, const PhysicalType& rhs) {
  UniversalLongLongInteger retval;

  retval = savantPlus((const UniversalLongLongInteger&) lhs.getVHDLData(),
		      (const UniversalLongLongInteger&) rhs.getVHDLData());
  return PhysicalType(ObjectBase::VARIABLE, retval);
}

PhysicalType 
savantMinus(const PhysicalType& lhs, const PhysicalType& rhs) {
  UniversalLongLongInteger retval;

  retval = savantMinus((const UniversalLongLongInteger&) lhs.getVHDLData(),
		       (const UniversalLongLongInteger&) rhs.getVHDLData());
  return PhysicalType(ObjectBase::VARIABLE, retval);
}

PhysicalType
savantUnaryPlus(const PhysicalType& operand) {
  return operand;
}

PhysicalType 
savantUnaryMinus(const PhysicalType& operand) {
  UniversalLongLongInteger retval = (UniversalLongLongInteger &) operand.object->readVal();

  retval = UniversalLongLongInteger((LONG) (-1LL * retval.val));
  return PhysicalType(ObjectBase::VARIABLE, retval);
}

PhysicalType
savantMultiply(const PhysicalType& lhs, const IntegerType& rhs) {
  UniversalLongLongInteger lhs_val, retval;
  UniversalInteger rhs_val;

  lhs_val = (UniversalLongLongInteger &) lhs.getVHDLData();
  rhs_val = (UniversalInteger &) rhs.getVHDLData();

  retval = savantMultiply(lhs_val, rhs_val);

  return PhysicalType(ObjectBase::VARIABLE, retval);
}


PhysicalType
savantMultiply(const IntegerType& lhs, const PhysicalType& rhs) {
  return savantMultiply(rhs, lhs);
}

PhysicalType
savantMultiply(const PhysicalType& lhs, const RealType& rhs) {
  UniversalLongLongInteger lhs_val, retval;
  UniversalReal rhs_val;

  lhs_val = (UniversalLongLongInteger &) lhs.getVHDLData();
  rhs_val = (UniversalReal &) rhs.getVHDLData();

  retval = savantMultiply(lhs_val, rhs_val);

  return PhysicalType(ObjectBase::VARIABLE, retval);
}

PhysicalType
savantMultiply(const RealType& lhs, const PhysicalType& rhs) {
  return savantMultiply(rhs, lhs);
}

IntegerType
savantDivide(const PhysicalType& lhs, const PhysicalType& rhs) {
  UniversalLongLongInteger lhs_val, rhs_val, retval;

  lhs_val = (UniversalLongLongInteger &) lhs.getVHDLData();
  rhs_val = (UniversalLongLongInteger &) rhs.getVHDLData();

  retval = savantDivide(lhs_val, rhs_val);

  return IntegerType(ObjectBase::VARIABLE, int(retval.val));
}

PhysicalType
savantDivide(const PhysicalType& lhs, const IntegerType& rhs) {
  UniversalLongLongInteger lhs_val, retval;
  UniversalInteger rhs_val;

  lhs_val = (UniversalLongLongInteger &) lhs.getVHDLData();
  rhs_val = (UniversalInteger &) rhs.getVHDLData();

  retval = savantDivide(lhs_val, rhs_val);

  return PhysicalType(ObjectBase::VARIABLE, retval.val);
}

PhysicalType
savantDivide(const PhysicalType& lhs, const RealType& rhs) {
  UniversalLongLongInteger lhs_val, retval;
  UniversalReal rhs_val;

  lhs_val = (UniversalLongLongInteger &) lhs.getVHDLData();
  rhs_val = (UniversalReal &) rhs.getVHDLData();

  retval = savantDivide(lhs_val, rhs_val);

  return PhysicalType(ObjectBase::VARIABLE, retval.val);
}

PhysicalType
savantAbs(const PhysicalType &lhs) {
  UniversalLongLongInteger lhs_val, retval;

  lhs_val = (UniversalLongLongInteger &) lhs.getVHDLData();
  retval  = savantAbs(lhs_val);
  
  return PhysicalType(ObjectBase::VARIABLE, retval.val);
}

PhysicalType
PhysicalType::LEFT(const phyInfo& pInfo) {
  return PhysicalType(ObjectBase::VARIABLE,
		      UniversalLongLongInteger(pInfo.get_left()));
}

PhysicalType
PhysicalType::RIGHT(const phyInfo& pInfo) {
  return PhysicalType(ObjectBase::VARIABLE, pInfo.get_left());
}

PhysicalType
PhysicalType::HIGH(const phyInfo& pInfo){
  if (pInfo.get_left() > pInfo.get_right()) {
    return PhysicalType(ObjectBase::VARIABLE,
			UniversalLongLongInteger(pInfo.get_left()));
  }
  else {
    return PhysicalType(ObjectBase::VARIABLE,
			UniversalLongLongInteger(pInfo.get_right()));
  }
}

PhysicalType
PhysicalType::LOW(const phyInfo& pInfo){
  if (pInfo.get_left() > pInfo.get_right()) {
    return PhysicalType(ObjectBase::VARIABLE,
			UniversalLongLongInteger(pInfo.get_right()));
  }
  else {
    return PhysicalType(ObjectBase::VARIABLE,
			UniversalLongLongInteger(pInfo.get_left()));
  }
}

EnumerationType
PhysicalType::ASCENDING(const phyInfo& pInfo){
  if (pInfo.get_direction() == to){
    return SAVANT_BOOLEAN_TRUE;
  }
  else {
    return SAVANT_BOOLEAN_FALSE;
  }
}


PhysicalType
PhysicalType::SUCC(const PhysicalType& x){
  UniversalLongLongInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val >= x.range.get_left() &&
     val < x.range.get_right()){
    val = val + 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val < x.range.get_left() &&
	  val >= x.range.get_right()){
    val = val + 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `SUCC attribute not within range ";abort();
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
}

PhysicalType
PhysicalType::PRED(const IntegerType& x){
  UniversalLongLongInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val > x.range.get_left() &&
     val <= x.range.get_right()){
    val = val - 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val <= x.range.get_left() &&
	  val > x.range.get_right()){
    val = val - 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `PRED attribute not within range ";abort();
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
}

PhysicalType
PhysicalType::LEFTOF(const PhysicalType& x){
  UniversalLongLongInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val > x.range.get_left() &&
     val <= x.range.get_right()){
    val = val - 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val <= x.range.get_left() &&
	  val > x.range.get_right()){
    val = val + 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `LEFTOF attribute not within range ";abort();
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
}


PhysicalType
PhysicalType::RIGHTOF(const PhysicalType& x){
  UniversalLongLongInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val >= x.range.get_left() &&
     val < x.range.get_right()){
    val = val + 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val < x.range.get_left() &&
	  val >= x.range.get_right()){
    val = val - 1;
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `RIGHTOF attribute not within range ";abort();
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
}

SavantstringType 
PhysicalType::IMAGE(const PhysicalType& x) {
  UniversalLongLongInteger value;
  value = x.getObject()->readVal();
  strstream string;
  string << value << x.range.get_unit((int)0) << ends;
  char* ptr = string.str();
  SavantstringType image(ObjectBase::VARIABLE,0,to,strlen(ptr) - 1,ptr);
  return image;
}

IntegerType
PhysicalType::POS(const PhysicalType& x, const phyInfo& pInfo){
  UniversalLongLongInteger val;
  val = x.getObject()->readVal();
  return IntegerType(ObjectBase::VARIABLE, (int) val.val);
}

PhysicalType
PhysicalType::VAL(const PhysicalType& x, const phyInfo& pInfo) {
  UniversalLongLongInteger val;
  val = x.getObject()->readVal();
  if(val >= pInfo.get_left() && val <= pInfo.get_right()){
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The Result of `VAL attribute not withing range";
    abort();
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
}

PhysicalType
PhysicalType::VAL(const IntegerType& x, const phyInfo& pInfo) {
  UniversalLongLongInteger val;
  val = x.getObject()->readVal();
  if(val >= pInfo.get_left() && val <= pInfo.get_right()){
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The Result of `VAL attribute not withing range";
    abort();
    return PhysicalType(ObjectBase::VARIABLE, val);
  }
}

const VHDLData&
PhysicalType::leftValue() {
  static UniversalLongLongInteger retValue(0);

  retValue = UniversalLongLongInteger(range.get_left());

  return retValue;
}

VTime
PhysicalType::getVTime() const {
  return VTime(longlongint((UniversalLongLongInteger &) object->readVal()));
}

TypeInfo&
PhysicalType::getTypeInfo() const {
  return (TypeInfo &) range;
}
