#include "standard.hh"
#include "Signal.hh"
#include "ImplicitSignal.hh"
#include "Variable.hh"
#include "SignalNetinfo.hh"
#include "STDTypes.hh"
#include <math.h>
#include "SavantstringType.hh"

IntegerType::IntegerType(ObjectBase::ObjectType objType): ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>; break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>; break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>; break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

IntegerType::IntegerType(ObjectBase::ObjectType objType, 
			 const UniversalInteger& val): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

IntegerType::IntegerType(ObjectBase::ObjectType objType, 
			 const IntegerType& value): 
  ScalarType(objType) {
  UniversalInteger val = (UniversalInteger&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }

  range = value.range;
}

IntegerType::IntegerType(bool alias, const IntegerType& actual) 
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
}

IntegerType::IntegerType(const IntegerType& value): ScalarType((const ScalarType &) value) {
  range = value.range;
}

IntegerType::IntegerType(ObjectBase::ObjectType objType, int i) : ScalarType(objType) {
  UniversalInteger val(i);

  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>(val); break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(val); break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(val); break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
}

IntegerType&
IntegerType::operator = (const IntegerType& value) {
  ((ScalarType &) *this) = (const ScalarType&) value;
  range = (const rangeInfo &) value.range;
  return *this;
}


//new constructors to hold the rangeInfo

IntegerType::IntegerType(ObjectBase::ObjectType objType,
			 const rangeInfo& rInfo): ScalarType(objType) {
  UniversalInteger initialValue((int) rInfo.get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL : 
    object = new Signal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL :
    object = new ImplicitSignal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::VARIABLE :
    object = new Variable<UniversalInteger>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO :
    object = new SignalNetinfo; break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Info
  range = rInfo;
} 

IntegerType::IntegerType(ObjectBase::ObjectType objType, const TypeInfo& typeInfo) : ScalarType(objType) {
  UniversalInteger initialValue((int) ((const rangeInfo &) typeInfo).get_left());
  
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalInteger>(initialValue);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalInteger>(initialValue);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Info
  range = (rangeInfo &) typeInfo;
}

IntegerType::IntegerType(ObjectBase::ObjectType objType, 
			 const UniversalInteger& val,
			 const rangeInfo& rInfo): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalInteger>(val);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalInteger>(val);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalInteger>(val);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Information
  range = rInfo;
}

IntegerType::IntegerType(ObjectBase::ObjectType objType, 
			 const UniversalInteger& val,
			 const enumInfo& rInfo): 
  ScalarType(objType) {
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalInteger>(val);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalInteger>(val);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalInteger>(val);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Information
  range = rangeInfo(rInfo.get_left(), rInfo.get_direction(), rInfo.get_right());
}

IntegerType::IntegerType(ObjectBase::ObjectType objType, 
			 const IntegerType& value,
			 const rangeInfo& rInfo): 
  ScalarType(objType) {
  UniversalInteger val = (UniversalInteger&) value.getVHDLData();
  switch(objType) {
  case ObjectBase::SIGNAL: 
    object = new Signal<UniversalInteger>(val);
    break;
  case ObjectBase::IMPLICIT_SIGNAL:
    object = new ImplicitSignal<UniversalInteger>(val);
    break;
  case ObjectBase::VARIABLE:
    object = new Variable<UniversalInteger>(val);
    break;
  case ObjectBase::SIGNAL_NETINFO:
    object = new SignalNetinfo;
    break;
  default:
    cerr << "ERROR: unknown object type" << endl;
    exit(-1);
  }
  //Copying the range Information
  range = rInfo;
} 

IntegerType::IntegerType(const IntegerType& value, 
			 const rangeInfo& rInfo): ScalarType(value) { 
  range = rInfo;
}


IntegerType::IntegerType(bool alias, const IntegerType& actual,
			 const rangeInfo& rInfo) 
  : ScalarType(actual.getObject()->getKind(), alias) {
  object = actual.getObject();
  range = rInfo;
}


Type 
IntegerType::get_kind() const {
  return INTEGER_TYPE;
}

IntegerType
savantPlus(const IntegerType& lhs, const IntegerType& rhs) {
  UniversalInteger retval;

  retval = savantPlus((const UniversalInteger&) lhs.getVHDLData(),
		      (const UniversalInteger&) rhs.getVHDLData());
  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType 
savantMinus(const IntegerType& lhs, const IntegerType& rhs) {
  UniversalInteger retval;

  retval = savantMinus((const UniversalInteger&) lhs.getVHDLData(),
		       (const UniversalInteger&) rhs.getVHDLData());
  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType
savantUnaryPlus(const IntegerType& operand) {
  return operand;
}

IntegerType 
savantUnaryMinus(const IntegerType& operand) {
  UniversalInteger retval = (UniversalInteger &) operand.object->readVal();

  retval = UniversalInteger( -1 * retval.val);
  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType
savantMultiply(const IntegerType& lhs, const IntegerType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;

  lhs_val = lhs.getVHDLData();
  rhs_val = rhs.getVHDLData();

  retval = savantMultiply(lhs_val, rhs_val);
  // retval = (VHDLData &) savantMultiply(lhs_val, rhs_val);

  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType
savantDivide(const IntegerType& lhs, const IntegerType& rhs) {
  UniversalInteger lhs_val, rhs_val, retval;

  lhs_val = lhs.getVHDLData();
  rhs_val = rhs.getVHDLData();

  retval = savantDivide(lhs_val, rhs_val);
  // retval = (VHDLData &) savantDivide(lhs_val, rhs_val);

  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType
savantMod(const IntegerType& lhs, const IntegerType& rhs) {
  UniversalInteger retval;
  
  retval = savantMod((const UniversalInteger&) lhs.getVHDLData(),
		     (const UniversalInteger&) rhs.getVHDLData());
  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType
savantRem(const IntegerType& lhs, const IntegerType& rhs) {
  UniversalInteger retval;

  retval = savantRem((const UniversalInteger&) lhs.getVHDLData(),
		     (const UniversalInteger&) rhs.getVHDLData());
  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType
savantPow(const IntegerType& lhs, const IntegerType& rhs) {
  UniversalInteger retval;

  retval = savantPow((const UniversalInteger&) lhs.getVHDLData(),
		     (const UniversalInteger&) rhs.getVHDLData());
  return IntegerType(ObjectBase::VARIABLE, retval);
}

IntegerType
savantAbs(const IntegerType& value) {
  UniversalInteger val = (UniversalInteger &) value.getVHDLData();

  return IntegerType(ObjectBase::VARIABLE, abs(val.val));
}


//The attributes of IntegerType

IntegerType 
IntegerType::LEFT(const rangeInfo& rInfo){
  return IntegerType(ObjectBase::VARIABLE, (int)rInfo.get_left());
}

IntegerType
IntegerType::RIGHT(const rangeInfo& rInfo){
  return IntegerType(ObjectBase::VARIABLE, (int)rInfo.get_right());
}

IntegerType
IntegerType::HIGH(const rangeInfo& rInfo){
  if (rInfo.get_left() > rInfo.get_right())
    return IntegerType(ObjectBase::VARIABLE, (int)rInfo.get_left());
  else
    return IntegerType(ObjectBase::VARIABLE, (int)rInfo.get_right());
}

IntegerType
IntegerType::LOW(const rangeInfo& rInfo){
  if (rInfo.get_left() > rInfo.get_right())
    return IntegerType(ObjectBase::VARIABLE, (int)rInfo.get_right());
  else
    return IntegerType(ObjectBase::VARIABLE, (int)rInfo.get_left());
}

EnumerationType
IntegerType::ASCENDING(const rangeInfo& rInfo){
  if (rInfo.get_direction() == to){
    return SAVANT_BOOLEAN_TRUE;
  }
  else {
    return SAVANT_BOOLEAN_FALSE;
  }
}
   
IntegerType
IntegerType::SUCC(const IntegerType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val >= x.range.get_left() &&
     val < x.range.get_right()){
    val = val + 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val < x.range.get_left() &&
	  val >= x.range.get_right()){
    val = val + 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `SUCC attribute not within range ";abort();
    return IntegerType(ObjectBase::VARIABLE, val);
  }
}

IntegerType
IntegerType::PRED(const IntegerType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val > x.range.get_left() &&
     val <= x.range.get_right()){
    val = val - 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val <= x.range.get_left() &&
	  val > x.range.get_right()){
    val = val - 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `PRED attribute not within range ";abort();
    return IntegerType(ObjectBase::VARIABLE, val);
  }
}

IntegerType
IntegerType::LEFTOF(const IntegerType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val > x.range.get_left() &&
     val <= x.range.get_right()){
    val = val - 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val < x.range.get_left() &&
	  val >= x.range.get_right()){
    val = val + 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `LEFTOF attribute not within range ";abort();
    return IntegerType(ObjectBase::VARIABLE, val);
  }
}

IntegerType
IntegerType::RIGHTOF(const IntegerType& x){
  UniversalInteger val = x.getObject()->readVal();
  if(x.range.get_direction() == to && val >= x.range.get_left() &&
     val < x.range.get_right()){
    val = val + 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else if(x.range.get_direction() == downto && val <= x.range.get_left() &&
	  val > x.range.get_right()){
    val = val - 1;
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The parameter of `RIGHTOF attribute not within range ";abort();
    return IntegerType(ObjectBase::VARIABLE, val);
  }
}

IntegerType
IntegerType::VAL(const IntegerType& x, const rangeInfo& rInfo){
  UniversalInteger val = x.getObject()->readVal();
  if((rInfo.get_direction() == to && val >= rInfo.get_left() &&
      val <= rInfo.get_right()) || 
     (rInfo.get_direction() == downto && val <= rInfo.get_left() &&
      val >= rInfo.get_right())){
    return IntegerType(ObjectBase::VARIABLE, val);
  }
  else {
    cerr << "The Result of `VAL attribute not withing range";abort();
    return IntegerType(ObjectBase::VARIABLE, val);
  }
}

IntegerType
IntegerType::VALUE(const SavantstringType& x, const rangeInfo&) {
  int length = x.get_number_of_elements();
  strstream value;
  char* ptr;
  for(int i=0; i < length; i++) {
    x.get_element(i).print(value);
  }
  value << ends;
  ptr = value.str();
  double val = atoi(ptr);
  IntegerType retval(ObjectBase::VARIABLE, UniversalInteger(val));
  return retval;
}

IntegerType
IntegerType::POS(const IntegerType& x, const rangeInfo& rInfo){
  UniversalInteger val = x.getObject()->readVal();
  return IntegerType(ObjectBase::VARIABLE, val);
}

SavantstringType
IntegerType::IMAGE(const IntegerType& x){
  UniversalInteger val;
  val = x.getObject()->readVal();
  strstream string;
  string << val << ends;
  char* ptr = string.str();
  return SavantstringType(ObjectBase::VARIABLE,0,to,strlen(ptr)-1, ptr);
}

const VHDLData&
IntegerType::leftValue() {
  static UniversalInteger retValue(0);
  
  retValue = UniversalInteger(range.get_left());
  
  return retValue;
}

TypeInfo&
IntegerType::getTypeInfo() const {
  return (TypeInfo &) range;
}
