#include "CallStack.hh"

#include "VHDLType.hh"
#include <stdarg.h>

#ifndef ASSERT
#ifdef DEVELOPER_ASSERTIONS
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#define ASSERT( x ) assert( x )
#else
#define ASSERT( x )
#endif
#endif

void 
CallStack::cleanStack() {
  StackElement *elem;

  while(numElements > 0) {
    elem = pop();
    delete [] elem->args;
  }
}

bool
CallStack::empty() const {
  return INT_TO_BOOL(numElements == 0);
}

void 
CallStack::push(StackElement *elem) {
  ASSERT(elem != NULL);
  if(numElements == 0) {
    stackTop = elem;
    stackBottom = elem;
    currentTop = elem;
    elem->next = NULL;
  } else {
    ASSERT(stackBottom != NULL);
    elem->next = stackTop;
    stackTop = elem;
  }
  numElements++;
}

void
CallStack::push(const int waitLabel, const int numArgs, ...) {
  VHDLType **args;
  va_list ap;
  register int i;
  StackElement *newElem = (StackElement *) new char[sizeof(StackElement)];

  va_start(ap, numArgs);
  if(numArgs > 0) {
    args = (VHDLType **) new char[numArgs * sizeof(VHDLType*)];
  } else {
    args = NULL;
  }

  for(i = 0; i < numArgs; i++) {
    args[i] = va_arg(ap, VHDLType*);
  }
  va_end(ap);
  
  newElem->args = args;
  newElem->waitLabel = waitLabel;
  newElem->numArgs = numArgs;
  push(newElem);
}

StackElement*
CallStack::pop() {
  ASSERT(numElements != 0);
  ASSERT(stackTop != NULL);
  StackElement *retval = stackTop;

  numElements--;
  stackTop = stackTop->next;
  return retval;
}

// Removes all the elements in the stack above and including the current
// pointer.
void
CallStack::popAboveCurrent() {
  ASSERT(numElements != 0);
  StackElement *elem;

  while(stackTop != currentTop) {
    elem = pop();
    delete elem->args;
    delete elem;
  }
  elem = pop();
  delete elem->args;
  delete elem;
}

StackElement*
CallStack::getTop() const {
  return stackTop;
}

StackElement*
CallStack::getCurrentTop() const {
  return currentTop;
}

void
CallStack::setCurrentToNext() {
  ASSERT(currentTop != NULL);
  currentTop = currentTop->next;
}

void
CallStack::setCurrentToTop() {
  currentTop = stackTop;
}

CallStack&
CallStack::operator = (const CallStack& stack) {
  StackElement *elem = stack.getTop();
  StackElement *newelem;
  while(elem != NULL) {
    newelem = new StackElement;
    newelem->numArgs = elem->numArgs;
    newelem->waitLabel = elem->waitLabel;
    newelem->args = new VHDLType*[elem->numArgs];
    for(register int i = 0; i < elem->numArgs; i++) {
      newelem->args[i] = elem->args[i]->clone();
      *newelem->args[i] = *elem->args[i];
    }

    push(newelem);
    elem = elem->next;
  }
  return *this;
}
