#ifndef ARRAYTYPE_HH
#define ARRAYTYPE_HH
//---------------------------------------------------------------------------
// Copyright (c) 1995-1997 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------
#include "ObjectBase.hh"
#include "ArrayInfo.hh"
#include "IntegerType.hh"
#include "VHDLType.hh"

class ScalarType;
class VectorBase;
class SignalBase;

class ArrayType : public VHDLType {
public:
  ArrayType(bool alias = false);
  ArrayType(ObjectBase::ObjectType, char *, const TypeInfo& = TypeInfo::NULL_TYPE_INFO):isCompositeResolvedType(false) {}
  ArrayType(ObjectBase::ObjectType, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  
  ArrayType(bool alias, ObjectBase::ObjectType, int , ArrayDirn_t, int, 
	    const ArrayType&, const ArrayInfo&);
  
  virtual ~ArrayType();
  
  // Note: The method "get_kind()" MUST NOT be overloaded by a derived
  // type.  This is to ensure that the type is recognized correctly.
  virtual Type get_kind() const;
  
  virtual void print(ostream& os) const;
  void setRange(ObjectBase::ObjectType, ArrayInfo*, int = 1, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  
  virtual VHDLType& operator[](const int pos) const;
  //  virtual VHDLType& operator[](const ScalarType& pos) const;
  
  virtual VHDLType& operator =(const VHDLType& val);
  virtual ArrayType& operator =(const ArrayType& val);
  VHDLType& assignVal(const VHDLType& val);
  
  virtual bool operator == (const VHDLType& val) const;
  
  virtual VHDLType& get_element(const int index) const;
  virtual VHDLType& get_array();
  virtual int get_number_of_elements() const;
  ArrayInfo* get_bounds() const;
  
  ArrayType* getNewArray(const ArrayInfo& newBounds, 
			 const ArrayInfo& actualBounds) const;
  
  virtual char* getString() const;
  
  virtual VHDLType* clone() const;
  
  ObjectBase* getObject() const;
  virtual ObjectBase::ObjectType getKind() const;
  
  int left() const;
  int right() const;
  ArrayDirn_t dirn() const;
  int length() const;
  
  int savantwrite(AccessVariable <char*> &line) const;
  int savantwrite(SavantlineType &line) const;
  int savantread(AccessVariable <char*> &line);
  int savantread(SavantlineType &line);
  
  //The TYPE's resolve is called only for composite resolved signals
  //This resolve goes down to first sub-element of the VHDLType and
  //calls the sub-elements resolve, but which actually does the resolution
  //for the whole composite type
  virtual VHDLType* resolve(VHDLKernelBase*);
  virtual void updateEffVal(const VHDLType*);
  virtual void setResolutionFunctionId(int resolutionFnId);
  virtual void setTypeConversionFunctionId(int typeConversionFnId);
  virtual void setParentCompositeType(VHDLType*);
  virtual void setCompositeResolvedSignal(bool);
  void setElaborationInfo(const VHDLType&);
  void setNumAttributes(int);
  void setAttrib(AttribType, VHDLType&);
  virtual SignalBase* locateSig(int);
  virtual SignalBase* findSigInBlock(int, int);
  virtual bool _is_composite_resolved_type() const;
  virtual void dump_connectivity_info(ofstream&);

  virtual bool _is_signal() const;
  
  //Code added for folding array types into kernel
  static IntegerType LEFT             (IntegerType&, const arrayTypeInfo&);
  static IntegerType RIGHT            (IntegerType&, const arrayTypeInfo&);
  static IntegerType HIGH             (IntegerType&, const arrayTypeInfo&);
  static IntegerType LOW              (IntegerType&, const arrayTypeInfo&);
  static IntegerType LENGTH           (IntegerType&, const arrayTypeInfo&);
  static EnumerationType ASCENDING  (IntegerType&, const arrayTypeInfo&);
  
  VectorBase* object;

  //The following pointer is used to specify the 
  //bouunds of an unconstrained array that is element off an array type.
  static ArrayInfo* rangeInfo;

  //This flag is to check whether this ArrayType is a composite resolved
  // type This flag will be set in setCompositeResolvedSignal. It can also
  // be set in SetParentCompositeType method of ArrayType.
  bool isCompositeResolvedType;

  //This holds the information about the ranges and dimensions
  arrayTypeInfo arrInfo;
};

ArrayType& savantAnd( const ArrayType& lhs, const ArrayType& rhs); 
ArrayType& savantOr( const ArrayType& lhs, const ArrayType& rhs); 
ArrayType& savantNand( const ArrayType& lhs, const ArrayType& rhs); 
ArrayType& savantNor( const ArrayType& lhs, const ArrayType& rhs);
ArrayType& savantXor( const ArrayType& lhs, const ArrayType& rhs); 
ArrayType& savantXnor( const ArrayType& lhs, const ArrayType& rhs); 
ArrayType& savantNot( const ArrayType& lhs); 

ArrayType& savantSLL( const ArrayType& lhs, const IntegerType& rhs);
ArrayType& savantSRL( const ArrayType& lhs, const IntegerType& rhs);
ArrayType& savantSLA( const ArrayType& lhs, const IntegerType& rhs);
ArrayType& savantSRA( const ArrayType& lhs, const IntegerType& rhs);
ArrayType& savantROL( const ArrayType& lhs, const IntegerType& rhs);
ArrayType& savantROR( const ArrayType& lhs, const IntegerType& rhs);

EnumerationType savantEqual(const ArrayType&, const ArrayType&);
EnumerationType savantNotEqual(const ArrayType&, const ArrayType&);
EnumerationType savantLessThan(const ArrayType&, const ArrayType&);
EnumerationType savantLessThanOrEqual(const ArrayType&, const ArrayType&);
EnumerationType savantGreaterThan(const ArrayType&, const ArrayType&);
EnumerationType savantGreaterThanOrEqual(const ArrayType&, const ArrayType&);

extern "C" bool eatwhite(AccessVariable<char*>& line);
typedef ArrayType ArrayType_event;
typedef ArrayType ArrayType_lastevent;

#endif

