
// Copyright (c) 1995-1999 The University of Cincinnati.
// All rights reserved. 

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Author: Dale E. Martin          dmartin@ece.uc.edu
//        Krishnan Subramani       skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: switch_file.cc,v 1.4 1999/07/23 21:08:29 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "library_manager.hh"
#include "switch_file.hh"
#include <fstream.h>
#include <strstream.h>
#include "file_manager.hh"

switch_file::switch_file(){
  file_output = false;
  file_name = NULL;
  create_via_temporaries = false;
}


switch_file::switch_file( int fd ) : ofstream( fd ){
  file_output = false;
  file_name = NULL;
  create_via_temporaries = false;
}

void
switch_file::move_temporary_files(const char *fileName) {
  ostrstream tmpFileStream;

  tmpFileStream << fileName << ".tmp" << ends;
  char *tmpFileName = tmpFileStream.str();
  
  if (file_manager::file_compare(tmpFileName, fileName) == 0) {
    // The files are one and the same. Therefore let the originalFile 
    // remain in place. Get rid of the temporary file.
    file_manager::unlink(tmpFileName);
  }
  else {
    // The new file is different from the old file (orignal file) so
    // move the new file (.ie. temporary) to the original file.
    file_manager::rename(tmpFileName, fileName);
  }

  delete [] tmpFileName;
}

void
switch_file::move_temporary_files(dl_list<file_record>* file_list) {
  file_record* fileRec = file_list->first();

  while (fileRec != NULL) {
    move_temporary_files(fileRec->get_file_name());
    fileRec = file_list->successor(fileRec);
  }
}

void
switch_file::move_temporary_files() {
  const int hash_table_size = file_table.get_size();

  for(int ht_entry = 0; (ht_entry < hash_table_size); ht_entry++) {
    move_temporary_files(file_table.get_entry(ht_entry));
  }
}
  
void
switch_file::reset(){
  if(good()){
    delete [] file_name;
    flush();
    close();
  }
  file_name = NULL;
  if (create_via_temporaries == true) {
    move_temporary_files();
  }
  file_table.reset();
}

char*
switch_file::get_file_name() {
  return file_name;
}

switch_file::~switch_file(){
  if( good() ){
    delete [] file_name;
    flush();
    close();
  }
}

void 
switch_file::set_file( char *name, char *extension, bool rewriteFlag ){
  char* tmp_file_name = NULL;
  
  if (file_output == true) {
    // If we have a file open, we need to flush and close it...
    if (good()) {
      delete [] file_name;
      flush();
      close();
    }

    ostrstream file_stream;
    ostrstream tmp_file_stream;
    
    file_stream << name;
    if (extension != NULL) {
      file_stream << extension;
    }
    
    file_stream << ends;
    file_name = file_stream.str();

    if (create_via_temporaries == true) {
      // write the output to a temporary file. Once all the file I/O is
      // complete if the old file is different from its corresponding temporary
      // file then the temporary file will be moved to the old file. Else the
      // old file will be left intact. This should help incremental development
      // a lot
      
      tmp_file_stream << file_name << ".tmp" << ends;
      tmp_file_name = tmp_file_stream.str();
    }
    else {
      tmp_file_name = file_name;
    }
    
    // If we've never opened this file before, we want to open it in "write"
    // mode. If the user wants to open a fresh file do that 


    if( (first_time( file_name ) == true) || (rewriteFlag == true) ){
      open( tmp_file_name, ios::out | ios::trunc );
    }
    else{
      open( tmp_file_name, ios::app );
    }

    if (create_via_temporaries) {
      delete [] tmp_file_name;
    }
    
    if( !good() ){
      cerr << "Error - switch_file.cc couldn't open " << file_name << endl;
    }
  }
}


void 
switch_file::set_file( bool prefix, char *name, char *extension,
		       bool rewriteFlag ){

  char *file_name;
  
  ostrstream file_stream;
  if(prefix == true){
    file_stream << IIRScram::_get_library_manager()->get_work_dir_name()
		<< "/";
  }
  
  file_stream << name << ends;
  
  file_name = file_stream.str();
  
  set_file(file_name, extension, rewriteFlag);
  delete [] file_name;
}


bool
switch_file::first_time( char *file_name ){
  file_record *record = file_table.hash_look( file_name );

  bool retval = !(record->get_used());
  record->set_used();
  
  return retval;
}
