#ifndef FILE_MANAGER_HH
#define FILE_MANAGER_HH

// Copyright (c) 1995-1999 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Author: Dale E. Martin          dmartin@ece.uc.edu

//---------------------------------------------------------------------------
//
// $Id: file_manager.hh,v 1.3 1999/10/05 03:01:51 dmartin Exp $
//
//---------------------------------------------------------------------------

class ifstream;

#include <sys/types.h>

class file_manager {
public:
  // The following enumeration gives the result of the "check_file_status" method.
  // OK - the file exists and is of the correct mode.
  // NOT_FOUND - the file doesn't exist.
  // NOT_TYPE - the file exists, but isn;t the right type of file.
  // ERROR - 
  enum file_status { OK, NOT_FOUND, NOT_TYPE, ERROR };
  enum file_type { REGULAR_FILE, DIRECTORY, DONTCARE };

  static file_status check_file_status( char *filename, file_type MODE = DONTCARE );
  
  static ifstream &get_istream( char *filename );
  
  static file_status make_directory( char *directory_name, mode_t mode = 0755 );

  static file_status change_directory( char *to_directory );

  static file_status unlink(const char *);
  static file_status rename(const char *, const char *);
  static int  file_compare(const char *, const char *);
  
  // For unix this returns "/".  For DOS, it would return "\".
  static const char *get_directory_separator();
  
  // This returns a NULL terminated array of strings containing
  // standard library directories on this platform.
  static const char **get_library_directories();
  
private:
  // This class wasn't intended to be instantiated - all of it's methods
  // are static, so it can be used without instantiation, and it has no
  // data for the same reason.
  file_manager(){};

  static const char *lib_dirs[];
};

#endif
