// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu


//---------------------------------------------------------------------------
// 
// $Id: IIRScram_TransactionAttribute.cc,v 1.3 1999/03/16 21:10:02 dmadhava Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_TransactionAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "StandardPackage.hh"
#include "symbol_table.hh"
#include "IIR_EnumerationTypeDefinition.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_TransactionAttribute::~IIRScram_TransactionAttribute() {}

void 
IIRScram_TransactionAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'TRANSACTION ";
}


IIR_TextLiteral *
IIRScram_TransactionAttribute::_build_attribute_name() {
  char *name = "transaction";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_TransactionAttribute::_get_subtype(){
  return StandardPackage::bit_type;
}

IIR_Declaration *
IIRScram_TransactionAttribute::_get_implicit_declaration( char *decl_name,
							  IIR_TypeDefinition *decl_type ){ 

  return _build_signal_declaration( decl_name, decl_type );
}

void 
IIRScram_TransactionAttribute::_publish_cc() {
  _cc_out << "*(";
  _publish_cc_signal_attribute("Transaction");
  _cc_out << ")";
}

void
IIRScram_TransactionAttribute::_publish_cc_necessary_decl_in_state() {
  _publish_cc_necessary_signal_decl_in_state(TRANSACTION, "_transaction");
}

// Initialization value of the signal, in UserState::initstate()
void
IIRScram_TransactionAttribute::_publish_cc_init_val() { 
  _cc_out << "UniversalInteger(0)";
}

void
IIRScram_TransactionAttribute::_publish_cc_name_in_caps() {
  _cc_out << "TRANSACTION";
}

void
IIRScram_TransactionAttribute::_publish_cc_attrib_type() {
  _cc_out << "signal";
}

void
IIRScram_TransactionAttribute::_publish_cc_necessary_decl_init(){}

void
IIRScram_TransactionAttribute::_publish_cc_elaborate() {
  get_prefix()->_publish_cc_elaborate();
  // _cc_out << "_";
  _cc_out << "_transaction";
}

void
IIRScram_TransactionAttribute::_publish_cc_sigtype() {
  _cc_out << " I_TRANSACTION;\n";
}

//void 
//IIRScram::_record() {}
//IIR * 
//IIRScram_TransactionAttribute::_transmute() {}

void
IIRScram_TransactionAttribute::_publish_cc_type_cast() {
  _cc_out << "(Signal<UniversalInteger>* ) ";
}

void
IIRScram_TransactionAttribute::_publish_cc_state_object_init() {
  _publish_cc_necessary_signal_state_object_init(TRANSACTION, "_transaction", TRUE);
}

void
IIRScram_TransactionAttribute::_publish_cc_necessary_copying() {
  _publish_cc_necessary_attribute_copying(TRANSACTION, "_transaction");
}

void
IIRScram_TransactionAttribute::_publish_cc_read_or_write(const char *fName, const char *sName) {
  _publish_cc_attribute_read_or_write(TRANSACTION, "_transaction", fName, sName);
}
