#ifndef IIRSCRAM_STATEMENT_HH
#define IIRSCRAM_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajsek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Statement.hh,v 1.2 1999/03/09 20:56:46 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_Statement.hh"

template <class type> class dl_list;
class IIRScram_WaitStatement;
class IIR_StatementList;
class IIR_Statement;
class IIR_TypeDefinition;
class IIR_SubprogramDeclaration;
class IIR_Name;
class IIR_List;
class IIR_CaseStatementAlternativeList;
class IIR_WaveformList;
class ostream;
class IIR_SimpleName;

class IIRScram_Statement : public IIRBase_Statement {

public:
  virtual set<IIR_Declaration> *_find_declarations( IIR_Name * );
  virtual void _get_signal_source_info(set<IIR_Declaration>* siginfo);
  virtual IIR_Boolean _has_statement_list();
  IIR_Boolean _is_statement() { return TRUE; }
  virtual IIR_Boolean _is_sequential_statement() { return FALSE; }

  IIR_Boolean _is_iir_statement(){ return TRUE; }

  virtual void _type_check();
					
  // This method does the type checking and resolution for a boolean
  // condition.  Pass in a conditional, and it will return it
  // resolved.  It will report any errors it finds (like that value
  // not being boolean).  This method is called by IIR_IfStatement,
  // IIR_ElsifStatement, and IIR_WhileLoopStatement...  (For it to be called 
  // from IIR_Elsif, this must be public!
  static IIR *_type_check_and_resolve_boolean_condition( IIR *condition );

  // These virtual methods are needed to support the type checking functions in the
  // protected section
  virtual IIR *_get_target();
  virtual void _set_target( IIR * );

  virtual IIR_DelayMechanism _get_delay_mechanism();
  virtual void _set_delay_mechanism( IIR_DelayMechanism );

  virtual IIR *_get_reject_time_expression();
  virtual void _set_reject_time_expression( IIR * );
	
  // These methods are needed for the type checking of case statements that occurs in
  // IIR_CaseStatement, and IIR_ConcurrentSelectedSignalAssignment.
  virtual IIR *_get_case_statement_expression();
  virtual void _set_case_statement_expression( IIR * );

  virtual IIR_TextLiteral *_get_declarator();
  virtual IIR_Label* _get_label();
  
  virtual IIR *_get_assertion_condition();
  virtual void _set_assertion_condition( IIR * );

  virtual IIR *_get_report_expression();
  virtual void _set_report_expression( IIR * );

  virtual IIR *_get_severity_expression();
  virtual void _set_severity_expression( IIR * );

  ostream &_print( ostream & );

  virtual IIR_Label *_find_instantiate_label( IIR_SimpleName * );

  virtual void _make_interface_visible( symbol_table * );

protected:

  IIRScram_Statement() { _mangled_label = NULL; }
  virtual ~IIRScram_Statement() = 0;

  // These methods are used in the type checking of signal assignment statements,
  // and concurrent selected signal assignment statements.
  void _type_check_target_and_waveform( IIR_WaveformList * );
  void _type_check_mechanism_and_time( IIR_WaveformList * );

  // This method handles the type checking of case statement expressions and their 
  // alternatives.  The return value is the resolved expression (if there is no error),
  // and NULL if there is an error.  The list is type checked in place.
  void _type_check_case_statement_expression( IIR_CaseStatementAlternativeList * );

  // The following methods apply to assertion statements, concurrent assertion
  // statements, and report statements.
  void _type_check_assertion_condition();
  void _type_check_report_expression();
  void _type_check_severity_expression();


  virtual void _mangle_label();
  virtual void _set_label(IIR_Label*);
  
private:
  IIR_Label *_mangled_label;
};
#endif
