#ifndef IIRSCRAM_SIMPLE_NAME_HH
#define IIRSCRAM_SIMPLE_NAME_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SimpleName.hh,v 1.2 1999/03/09 20:56:41 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_SimpleName.hh"
class IIR_Identifier;

class IIRScram_SimpleName : public IIRBase_SimpleName {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _publish_cc_data();
  void _publish_cc_bounds();
  void _publish_cc_elaborate();
  void _publish_cc_wait_data();

  IIR_TextLiteral * _get_declarator();

  ostream &_print( ostream &os );

  set<IIR_Declaration> *_symbol_lookup();
  set<IIR_Declaration> *_symbol_lookup( set<IIR_Declaration> * );

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0);

  IIR_TypeDefinition *_determine_rval_in_set( set<IIR_TypeDefinition> *search_in,
					      IIR_TypeDefinition *looking_for );

  IIR_Declaration *_determine_decl_in_set( set<IIR_Declaration> *search_in,
					   IIR_TypeDefinition *looking_for );

  IIR *_rval_to_decl( IIR_TypeDefinition * );
  IIR *_decl_to_decl( IIR_Declaration * );

  IIR *_rval_to_decl( IIR_TypeDefinition *, IIR_TypeDefinition * );
  IIR *_rval_to_decl( IIR_Declaration *, IIR_TypeDefinition * );

  IIR_Boolean _is_component_decl() { return TRUE; }
  
  void _type_check( set<IIR_TypeDefinition> * );
  IIR_TextLiteral *_get_string();

  char *_convert_to_library_name();

  IIR *_clone();

protected:
  IIRScram_SimpleName() {}
  virtual ~IIRScram_SimpleName() = 0;
    
private:

  // This method looks at what this name is about to resolve to and decides
  // if it should be returning a function call instead.  So, it will return
  // either a function call, or the declaration passed in.
  IIR *_convert_to_function_call( IIR_Declaration * );
};
#endif
