// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajaske@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SharedVariableDeclaration.cc,v 1.2 1999/03/09 20:56:34 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRScram_SharedVariableDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Identifier.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_AttributeSpecificationList.hh"

IIRScram_SharedVariableDeclaration::~IIRScram_SharedVariableDeclaration() {}

void 
IIRScram_SharedVariableDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " shared variable ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";
  get_subtype()->_publish_vhdl(_vhdl_out);
  if(get_value() != NULL) {
    _vhdl_out << " := ";
    get_value()->_publish_vhdl(_vhdl_out);
  }
  _vhdl_out << ";\n";
}

IIRScram_Declaration::declaration_type 
IIRScram_SharedVariableDeclaration::_get_type(){
   return SHARED_VARIABLE;
}

