
#ifndef IIRSCRAM_SELECTED_NAME_HH
#define IIRSCRAM_SELECTED_NAME_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SelectedName.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_SelectedName.hh"
template <class type> class set;
class IIR_Declaration;
class IIR_GenericList;
class IIR_PortList;

class IIRScram_SelectedName : public IIRBase_SelectedName {

public:

  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _publish_cc_initialization_value();
  void _publish_cc_name();
  
  void _publish_cc_state_object_init();
  IIR_Declaration* _get_prefix_declaration();
  IIR_Declaration* _get_package_declaration();

  ostream &_print( ostream & );

  set<IIR_Declaration> *_symbol_lookup();
  //  set<IIR_Declaration> *_find_in_library();
  
  IIR *_get_suffix();
  char *_convert_to_library_name();
  void _type_check( set<IIR_TypeDefinition> * );
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0);
  IIR *_rval_to_decl( IIR_TypeDefinition * );
  IIR *_decl_to_decl( IIR_Declaration * );

  IIR_Boolean _is_resolved();
  IIR_Boolean _is_signal();
  IIR_Boolean _is_variable();
  IIR_Boolean _is_object();
  IIR_Boolean _is_readable();
  IIR_Boolean _is_writable();
  IIR_Boolean _is_type();

  IIR_Boolean _is_entity_decl();
  IIR_Boolean _is_configuration_decl();
  
  IIR_Boolean _is_by_all();

  IIR_Boolean _is_locally_static();
  IIR_Boolean _is_globally_static();
  IIR_SignalKind _get_signal_kind();
    
  IIR_TypeDefinition *_get_subtype();

  void _publish_cc_bounds();
  void _add_decl_into_cgen_symbol_table();
  
  void _set_suffix(IIR *suffix);

  void _build_lib( IIR_LibraryUnit * );
  void _publish_cc_declarator();
  void _publish_cc_elaborate();
  void _set_passed_through_out_port(IIR_Boolean);
  
  void _make_interface_visible( symbol_table * );
  void _come_into_scope( symbol_table * );
  void _come_out_of_scope( symbol_table * );
  
  IIR_GenericList *_get_generic_list();
  IIR_PortList *_get_port_list();

  IIR *_clone();

  set<IIR_Declaration> *_get_implicit_declarations(){ return _implicit_decls; }
  void _set_implicit_declarations(set<IIR_Declaration> *id){ _implicit_decls = id; }

  IIR_TypeDefinition *_get_rval_pointed_at();

protected:
  
  IIRScram_SelectedName(){ _implicit_decls = NULL; }
  virtual ~IIRScram_SelectedName() = 0;
    
private:
  set<IIR_Declaration> *_implicit_decls;
};

#endif
