// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_RangeTypeDefinition.cc,v 1.2 1999/03/09 20:56:08 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_RangeTypeDefinition.hh"
#include "IIR_Declaration.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_Identifier.hh"
#include <strstream.h>
#include "error_func.hh"

IIRScram_RangeTypeDefinition::~IIRScram_RangeTypeDefinition() {}

void 
IIRScram_RangeTypeDefinition::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_left() != NULL && get_right() != NULL);

  _publish_vhdl_constraint(_vhdl_out);
}

void 
IIRScram_RangeTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  if (get_left() == NULL && get_right() == NULL) {
    // unconstrained array...
    get_base_type()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " range <>";
  }
  else {
    _vhdl_out << "range ";
    _publish_vhdl_constraint(_vhdl_out);
  }
}


void
IIRScram_RangeTypeDefinition::_publish_vhdl_constraint(ostream &_vhdl_out) {
  if (get_left() == NULL && get_right() == NULL) {
    // unconstrained array...
    get_base_type()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " range <>";
  }
  else {
    ASSERT(get_left() != NULL && get_right() != NULL);
    ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);
    
    get_left()->_publish_vhdl(_vhdl_out);
    
    if( _is_ascending_range() == TRUE ){
      _vhdl_out << " to ";
    }
    else {
      _vhdl_out << " downto ";
    }

    get_right()->_publish_vhdl(_vhdl_out);
  }
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_range() {
  ASSERT(get_left() != NULL && get_right() != NULL);

  get_left()->_publish_cc_universal_value();
  _cc_out << ", ";

  ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);

  if( _is_ascending_range() == TRUE ){
    _cc_out << "to, ";
  }
  else {
    _cc_out << "downto, ";
  }

  get_right()->_publish_cc_universal_value();
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_bounds() {
  ASSERT(get_left() != NULL && get_right() != NULL);
  _cc_out << "ArrayInfo(";
  get_left()->_publish_cc_universal_value();
  _cc_out << ", ";

  ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);

  if( _is_ascending_range() == TRUE ){
    _cc_out << "to, ";
  }
  else {
    _cc_out << "downto, ";
  }

  get_right()->_publish_cc_universal_value();
  _cc_out << ")";
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_universal_type() {
  _cc_out << "UniversalInteger";
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_kernel_type() {
  _cc_out << "IntegerType";
}

IIR_TypeDefinition *
IIRScram_RangeTypeDefinition::_get_new_subtype(){
  ostrstream err;

  err << "Internal error - IIRScram_RangeTypeDefinition::_get_new_subtype() called.";
  err << "This shouldn't happen..." << ends;

  report_error( this, err );
  abort();

  return NULL;
}
