
#ifndef IIRSCRAM_PHYSICAL_TYPE_DEFINITION_HH
#define IIRSCRAM_PHYSICAL_TYPE_DEFINITION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PhysicalTypeDefinition.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_PhysicalTypeDefinition.hh"

class IIR_PhysicalTypeDefinition;

class IIRScram_PhysicalTypeDefinition : public IIRBase_PhysicalTypeDefinition {

public:
  IIR_Boolean _is_numeric_type() { return TRUE; }
  IIR_Boolean _is_physical_type() { return TRUE; }
  IIR_Boolean _is_iir_physical_type_definition() { return TRUE; }

  void _publish_vhdl_type_decl(ostream &);

  bool _is_time();
  void _publish_cc_elaborate();
  void _publish_cc_left();
  void _publish_cc_right();
  void _publish_cc_universal_type();
  void _publish_cc_kernel_type();

  void _publish_cc_data_members();
  void _publish_cc_decl_cc();

  void _publish_cc_multiply_operator_prototype();
  void _publish_cc_divide_operator_prototype();

  void _publish_cc_multiply_operator();
  void _publish_cc_divide_operator();

  //The following function publishes the function for the
  // `IMAGE attribute for integer Type definition
  virtual void _publish_cc_attribute_image();

  //The following function publishes the function for the
  // `VALUE attribute for integer Type definition
  virtual void _publish_cc_attribute_value();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
  void _publish_cc_type_string();
  
  virtual IIR_TypeDefinition *_get_new_subtype();
  virtual IIR *_clone();
  virtual void _clone( IIR_PhysicalTypeDefinition * );


protected:
  
  IIRScram_PhysicalTypeDefinition() {};
  virtual ~IIRScram_PhysicalTypeDefinition() = 0;

  void _build_implicit_operators( set<IIR_Declaration> * );
    
private:
 
};

#endif
