#ifndef IIRSCRAM_INTERFACE_DECLARATION_HH
#define IIRSCRAM_INTERFACE_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_InterfaceDeclaration.hh,v 1.2 1999/03/09 20:55:07 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_InterfaceDeclaration.hh"

template <class type> class set;
class IIR_TypeDefinition;
class IIR_List;

class IIRScram_InterfaceDeclaration : public IIRBase_InterfaceDeclaration {

public:
  IIR_Boolean _attach_attribute_specification( IIR_AttributeSpecification * );

  IIR_TypeDefinition *_get_subtype();

  void _publish_vhdl_mode(ostream &);
  
  ostream &_print( ostream & );

  IIR_Boolean _is_object() { return TRUE;}
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_record_type();
  IIR_Boolean _is_iir_interface_declaration(){ return TRUE; }

  IIR_TypeDefinition *_get_type_of_element( int );

  IIR_Int32 _get_num_indexes();
  void _clone(IIRScram_InterfaceDeclaration*);

  IIR_Boolean _is_readable();
  IIR_Boolean _is_writable();
  
  IIR_Boolean _is_interface() { return TRUE; };
  IIR_Boolean _is_optional();

  virtual void _publish_cc_decl_subprogram_arg(IIR_Boolean _to_publish_default_argument);
  virtual void _publish_cc_constructor_args();
  void _publish_cc_bounds();
  void _publish_cc_universal_type();
  void _publish_cc_value();
  void _publish_cc_initialization_value();

  void _add_declarations_in_initializations();
  void _add_decl_into_cgen_symbol_table();
  virtual IIR_Mode _get_mode();

  // The following enumeration is used to for the parser to give enough context
  // to do proper type checking on interface declarations.  (For instance, a signal
  // PARAMETER can't have initialization, but a signal PORT can.)
  enum _InterfaceListType {
    PORT_INTERFACE_LIST,
    GENERIC_INTERFACE_LIST,
    PARAMETER_INTERFACE_LIST
  };

  virtual void _type_check( _InterfaceListType ) = 0;
  virtual void _type_check( );
  
protected:
  IIRScram_InterfaceDeclaration() {}
  virtual ~IIRScram_InterfaceDeclaration() = 0;
    
private:
};
#endif





